/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.beanio.BeanReader;
import org.beanio.BeanReaderErrorHandler;
import org.beanio.StreamFactory;
import org.beanio.internal.util.LocaleUtil;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.BeanIOItemReaderWriterBase;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class BeanIOItemReader
extends BeanIOItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected Class errorHandler;
    @Inject
    @BatchProperty
    protected String locale;
    private BeanReader beanReader;
    protected int currentPosition;

    public void open(Serializable checkpoint) throws Exception {
        int startRowNumber;
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (this.start == 0) {
            this.start = 1;
        }
        int n = startRowNumber = checkpoint == null ? this.start : (Integer)checkpoint;
        if (startRowNumber < this.start || startRowNumber > this.end || startRowNumber < 0) {
            throw SupportMessages.MESSAGES.invalidStartPosition(startRowNumber, this.start, this.end);
        }
        this.mappingFileKey = new BeanIOItemReaderWriterBase.StreamFactoryKey(this.jobContext, this.streamMapping);
        StreamFactory streamFactory = BeanIOItemReader.getStreamFactory(this.streamFactoryLookup, this.mappingFileKey, this.mappingProperties);
        InputStream inputStream = BeanIOItemReader.getInputStream(this.resource, false);
        InputStreamReader inputReader = this.charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.charset);
        this.beanReader = streamFactory.createReader(this.streamName, (Reader)new BufferedReader(inputReader), LocaleUtil.parseLocale((String)this.locale));
        if (this.errorHandler != null) {
            this.beanReader.setErrorHandler((BeanReaderErrorHandler)this.errorHandler.newInstance());
        }
        if (startRowNumber > 1) {
            this.beanReader.skip(startRowNumber - 1);
            this.currentPosition += startRowNumber - 1;
        }
    }

    public Object readItem() throws Exception {
        if (++this.currentPosition > this.end) {
            return null;
        }
        Object readValue = this.beanReader.read();
        if (!this.skipBeanValidation) {
            ItemReaderWriterBase.validate(readValue);
        }
        return readValue;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.currentPosition);
    }

    public void close() throws Exception {
        if (this.beanReader != null) {
            this.beanReader.close();
            this.beanReader = null;
            this.mappingFileKey = null;
        }
    }
}

