/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.InputDecorator;
import java.io.Serializable;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.JsonItemReaderWriterBase;
import org.jberet.support.io.MappingJsonFactoryObjectFactory;

@Named
@Dependent
public class JsonItemReader
extends JsonItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonParserFeatures;
    @Inject
    @BatchProperty
    protected String deserializationProblemHandlers;
    @Inject
    @BatchProperty
    protected Class inputDecorator;
    private JsonParser jsonParser;
    private JsonToken token;
    private int rowNumber;

    public void open(Serializable checkpoint) throws Exception {
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (checkpoint != null) {
            this.start = (Integer)checkpoint;
        }
        if (this.start > this.end) {
            throw SupportMessages.MESSAGES.invalidStartPosition((Integer)checkpoint, this.start, this.end);
        }
        this.initJsonFactoryAndObjectMapper();
        this.jsonParser = JsonItemReader.configureJsonParser(this, this.inputDecorator, this.deserializationProblemHandlers, this.jsonParserFeatures);
    }

    public Object readItem() throws Exception {
        if (this.rowNumber >= this.end) {
            return null;
        }
        int nestedObjectLevel = 0;
        while (true) {
            this.token = this.jsonParser.nextToken();
            if (this.token == null) {
                return null;
            }
            if (this.token == JsonToken.START_OBJECT) {
                if (++nestedObjectLevel == 1) {
                    ++this.rowNumber;
                } else if (nestedObjectLevel < 1) {
                    throw SupportMessages.MESSAGES.unexpectedJsonContent(this.jsonParser.getCurrentLocation());
                }
                if (this.rowNumber < this.start) continue;
                break;
            }
            if (this.token != JsonToken.END_OBJECT) continue;
            --nestedObjectLevel;
        }
        Object readValue = this.objectMapper.readValue(this.jsonParser, this.beanType);
        if (!this.skipBeanValidation) {
            ItemReaderWriterBase.validate(readValue);
        }
        return readValue;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.rowNumber);
    }

    public void close() throws Exception {
        if (this.jsonParser != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            if (this.deserializationProblemHandlers != null) {
                this.objectMapper.clearProblemHandlers();
            }
            this.jsonParser.close();
            this.jsonParser = null;
        }
    }

    protected static JsonParser configureJsonParser(JsonItemReaderWriterBase batchReaderArtifact, Class<?> inputDecorator, String deserializationProblemHandlers, Map<String, String> jsonParserFeatures) throws Exception {
        if (inputDecorator != null) {
            batchReaderArtifact.jsonFactory.setInputDecorator((InputDecorator)inputDecorator.newInstance());
        }
        JsonParser jsonParser = batchReaderArtifact.jsonFactory.createParser(JsonItemReader.getInputStream(batchReaderArtifact.resource, false));
        if (deserializationProblemHandlers != null) {
            MappingJsonFactoryObjectFactory.configureDeserializationProblemHandlers(batchReaderArtifact.objectMapper, deserializationProblemHandlers, batchReaderArtifact.getClass().getClassLoader());
        }
        SupportLogger.LOGGER.openingResource(batchReaderArtifact.resource, batchReaderArtifact.getClass());
        if (jsonParserFeatures != null) {
            for (Map.Entry<String, String> e : jsonParserFeatures.entrySet()) {
                JsonParser.Feature feature;
                String key = e.getKey();
                String value = e.getValue();
                try {
                    feature = JsonParser.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportMessages.MESSAGES.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    jsonParser.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    jsonParser.configure(feature, false);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, value, key);
            }
        }
        return jsonParser;
    }
}

