/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.io.InputDecorator;
import com.fasterxml.jackson.core.io.OutputDecorator;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.jberet.support._private.SupportMessages;

public final class NoMappingJsonFactoryObjectFactory
implements ObjectFactory {
    private volatile JsonFactory jsonFactoryCached;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        JsonFactory jsonFactory = this.jsonFactoryCached;
        if (jsonFactory == null) {
            NoMappingJsonFactoryObjectFactory noMappingJsonFactoryObjectFactory = this;
            synchronized (noMappingJsonFactoryObjectFactory) {
                Object jsonFactoryFeatures;
                jsonFactory = this.jsonFactoryCached;
                if (jsonFactory == null) {
                    this.jsonFactoryCached = jsonFactory = new JsonFactory();
                }
                if ((jsonFactoryFeatures = environment.get("jsonFactoryFeatures")) != null) {
                    NoMappingJsonFactoryObjectFactory.configureJsonFactoryFeatures(jsonFactory, (String)jsonFactoryFeatures);
                }
                NoMappingJsonFactoryObjectFactory.configureInputDecoratorAndOutputDecorator(jsonFactory, environment);
            }
        }
        return jsonFactory;
    }

    static void configureInputDecoratorAndOutputDecorator(JsonFactory jsonFactory, Hashtable<?, ?> environment) throws Exception {
        Object outputDecorator;
        Object inputDecorator = environment.get("inputDecorator");
        if (inputDecorator != null) {
            Class<?> inputDecoratorClass = NoMappingJsonFactoryObjectFactory.class.getClassLoader().loadClass((String)inputDecorator);
            jsonFactory.setInputDecorator((InputDecorator)inputDecoratorClass.newInstance());
        }
        if ((outputDecorator = environment.get("outputDecorator")) != null) {
            Class<?> outputDecoratorClass = NoMappingJsonFactoryObjectFactory.class.getClassLoader().loadClass((String)outputDecorator);
            jsonFactory.setOutputDecorator((OutputDecorator)outputDecoratorClass.newInstance());
        }
    }

    static void configureJsonFactoryFeatures(JsonFactory jsonFactory, String jsonFactoryFeatures) {
        StringTokenizer st = new StringTokenizer(jsonFactoryFeatures, ",");
        while (st.hasMoreTokens()) {
            JsonFactory.Feature feature;
            String[] pair = NoMappingJsonFactoryObjectFactory.parseSingleFeatureValue(st.nextToken().trim());
            String key = pair[0];
            String value = pair[1];
            try {
                feature = JsonFactory.Feature.valueOf((String)key);
            }
            catch (Exception e1) {
                throw SupportMessages.MESSAGES.unrecognizedReaderWriterProperty(key, value);
            }
            if ("true".equals(value)) {
                if (feature.enabledByDefault()) continue;
                jsonFactory.configure(feature, true);
                continue;
            }
            if ("false".equals(value)) {
                if (!feature.enabledByDefault()) continue;
                jsonFactory.configure(feature, false);
                continue;
            }
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, value, key);
        }
    }

    static String[] parseSingleFeatureValue(String pair) {
        int i = pair.indexOf(61);
        String[] result = new String[2];
        if (i > 0) {
            result[0] = pair.substring(0, i).trim();
            result[1] = pair.substring(i + 1).trim();
        } else {
            result[0] = pair;
            result[1] = null;
        }
        return result;
    }
}

