/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;

@Named
@Dependent
public class JdbcBatchlet
implements Batchlet {
    @Inject
    @BatchProperty
    protected String sqls;
    @Inject
    @BatchProperty
    protected String dataSourceLookup;
    @Inject
    @BatchProperty
    protected String url;
    @Inject
    @BatchProperty
    protected String user;
    @Inject
    @BatchProperty
    protected String password;
    @Inject
    @BatchProperty
    protected Map<String, String> properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process() throws Exception {
        String result;
        block27: {
            Connection connection = null;
            Statement statement = null;
            if (this.sqls == null || (this.sqls = this.sqls.trim()).length() == 0) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.sqls, "sqls");
            }
            try {
                int[] updateCounts;
                if (this.dataSourceLookup != null) {
                    DataSource dataSource = (DataSource)InitialContext.doLookup(this.dataSourceLookup);
                    connection = dataSource.getConnection();
                } else {
                    if (this.url == null) {
                        throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "url");
                    }
                    Properties dbProperties = new Properties();
                    if (this.properties != null) {
                        dbProperties.putAll(this.properties);
                    }
                    if (this.user != null) {
                        dbProperties.put("user", this.user.trim());
                    }
                    if (this.password != null) {
                        dbProperties.put("password", this.password.trim());
                    }
                    connection = DriverManager.getConnection(this.url, dbProperties);
                }
                String[] sqlArray = this.sqls.split(";");
                statement = connection.createStatement();
                if (sqlArray.length == 0) {
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.sqls, "sqls");
                }
                if (sqlArray.length == 1) {
                    SupportLogger.LOGGER.addingSql(sqlArray[0]);
                    statement.execute(sqlArray[0]);
                    int updateCount = statement.getUpdateCount();
                    result = String.valueOf(updateCount);
                    break block27;
                }
                for (String sql : sqlArray) {
                    if ((sql = sql.trim()).length() <= 0) continue;
                    SupportLogger.LOGGER.addingSql(sql);
                    statement.addBatch(sql);
                }
                try {
                    updateCounts = statement.executeBatch();
                }
                catch (SQLException sqlException) {
                    for (SQLException nextException = sqlException.getNextException(); nextException != null; nextException = nextException.getNextException()) {
                        SupportLogger.LOGGER.error(nextException.toString());
                    }
                    if (sqlException instanceof BatchUpdateException) {
                        updateCounts = ((BatchUpdateException)sqlException).getUpdateCounts();
                    }
                    throw sqlException;
                }
                result = Arrays.toString(updateCounts);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return result;
    }

    public void stop() throws Exception {
    }
}

