/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.batch.runtime.context.StepContext;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;

@Named
@Dependent
public class OsCommandBatchlet
implements Batchlet {
    @Inject
    protected StepContext stepContext;
    @Inject
    @BatchProperty
    protected String commandLine;
    @Inject
    @BatchProperty
    protected List<String> commandArray;
    @Inject
    @BatchProperty
    protected File workingDir;
    @Inject
    @BatchProperty
    protected int[] commandOkExitValues;
    @Inject
    @BatchProperty
    protected long timeoutSeconds;
    @Inject
    @BatchProperty
    protected Map<String, String> environment;
    @Inject
    @BatchProperty
    protected Class streamHandler;
    private ExecuteWatchdog watchdog;
    private volatile boolean isStopped;

    public String process() throws Exception {
        CommandLine commandLineObj;
        DefaultExecutor executor = new DefaultExecutor();
        if (this.commandLine != null) {
            commandLineObj = CommandLine.parse((String)this.commandLine);
        } else {
            if (this.commandArray == null) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "commandArray");
            }
            if (this.commandArray.isEmpty()) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.commandArray.toString(), "commandArray");
            }
            commandLineObj = new CommandLine(this.commandArray.get(0));
            int len = this.commandArray.size();
            if (len > 1) {
                for (int i = 1; i < len; ++i) {
                    commandLineObj.addArgument(this.commandArray.get(i));
                }
            }
        }
        if (this.workingDir != null) {
            executor.setWorkingDirectory(this.workingDir);
        }
        if (this.streamHandler != null) {
            executor.setStreamHandler((ExecuteStreamHandler)this.streamHandler.newInstance());
        }
        SupportLogger.LOGGER.runCommand(commandLineObj.getExecutable(), Arrays.toString(commandLineObj.getArguments()), executor.getWorkingDirectory().getAbsolutePath());
        if (this.commandOkExitValues != null) {
            executor.setExitValues(this.commandOkExitValues);
        }
        this.watchdog = new ExecuteWatchdog(this.timeoutSeconds > 0L ? this.timeoutSeconds * 1000L : -1L);
        executor.setWatchdog(this.watchdog);
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        executor.execute(commandLineObj, this.environment, (ExecuteResultHandler)resultHandler);
        resultHandler.waitFor();
        ExecuteException exception = resultHandler.getException();
        if (exception != null) {
            this.stepContext.setExitStatus(String.valueOf(resultHandler.getExitValue()));
            if (!this.isStopped) {
                throw exception;
            }
            SupportLogger.LOGGER.warn("", (Throwable)exception);
        }
        return String.valueOf(resultHandler.getExitValue());
    }

    public void stop() throws Exception {
        if (this.watchdog != null) {
            this.isStopped = true;
            this.watchdog.destroyProcess();
        }
    }
}

