/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.RestItemReaderWriterBase;

@Named
@Dependent
public class RestItemWriter
extends RestItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String mediaType;
    protected MediaType mediaTypeInstance;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        if (this.httpMethod == null) {
            this.httpMethod = "POST";
        } else {
            this.httpMethod = this.httpMethod.toUpperCase(Locale.ENGLISH);
            if (!"POST".equals(this.httpMethod) && !"PUT".equals(this.httpMethod)) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.httpMethod, "httpMethod");
            }
        }
        this.mediaTypeInstance = this.mediaType != null ? MediaType.valueOf((String)this.mediaType) : MediaType.APPLICATION_JSON_TYPE;
    }

    public void writeItems(List<Object> items) throws Exception {
        WebTarget target = this.client.target(this.restUrl);
        Entity entity = Entity.entity(items, (MediaType)this.mediaTypeInstance);
        Response response = "POST".equals(this.httpMethod) ? target.request().post(entity) : target.request().put(entity);
        Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
        if (statusFamily == Response.Status.Family.CLIENT_ERROR || statusFamily == Response.Status.Family.SERVER_ERROR) {
            throw SupportMessages.MESSAGES.restApiFailure(response.getStatus(), response.getStatusInfo().getReasonPhrase(), response.getEntity());
        }
    }

    public Serializable checkpointInfo() {
        return null;
    }
}

