/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.ArtemisItemReaderWriterBase;

@Named
@Dependent
public class ArtemisItemWriter
extends ArtemisItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected boolean durableMessage;
    protected ClientProducer producer;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        this.producer = this.session.createProducer(this.queueAddress);
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            ClientMessage msg;
            if (item instanceof ClientMessage) {
                msg = (ClientMessage)item;
            } else if (item instanceof String) {
                msg = this.session.createMessage((byte)3, this.durableMessage);
                msg.getBodyBuffer().writeString((String)item);
            } else {
                msg = this.session.createMessage((byte)2, this.durableMessage);
                msg.getBodyBuffer().writeBytes(ArtemisItemWriter.objectToBytes(item));
            }
            this.producer.send((Message)msg);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (ActiveMQException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close Artemis consumer %s%n", this.producer);
            }
            this.producer = null;
        }
    }
}

