/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.UnicodeBOMInputStream;

public abstract class ItemReaderWriterBase {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    @Inject
    @BatchProperty
    protected String resource;
    @Inject
    @BatchProperty
    protected boolean skipBeanValidation;
    boolean skipWritingHeader;

    public static Validator getValidator() {
        return Holder.validator;
    }

    public static void validate(Object object) {
        Set violations;
        if (object != null && (violations = ItemReaderWriterBase.getValidator().validate(object, new Class[0])).size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ConstraintViolation vio : violations) {
                sb.append(NEW_LINE).append(vio.getConstraintDescriptor()).append(NEW_LINE).append(NEW_LINE);
                sb.append(vio.getRootBean()).append(NEW_LINE);
                sb.append(vio.getLeafBean()).append(NEW_LINE);
                sb.append(vio.getPropertyPath()).append(NEW_LINE);
                sb.append(vio.getInvalidValue()).append(NEW_LINE);
                sb.append(vio.getMessage()).append(NEW_LINE).append(NEW_LINE);
            }
            throw new ConstraintViolationException(sb.toString(), violations);
        }
    }

    private static Validator getValidator0() {
        Validator v;
        try {
            v = (Validator)InitialContext.doLookup("java:comp/Validator");
        }
        catch (NamingException e) {
            ValidatorFactory vf = Validation.buildDefaultValidatorFactory();
            v = vf.getValidator();
        }
        return v;
    }

    protected static InputStream getInputStream(String inputResource, boolean detectBOM) {
        InputStream inputStream;
        if (inputResource == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "resource");
        }
        try {
            try {
                URL url = new URL(inputResource);
                inputStream = url.openStream();
            }
            catch (MalformedURLException e) {
                SupportLogger.LOGGER.tracef("The resource %s is not a URL, %s%n", inputResource, e);
                File file = new File(inputResource);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                }
                SupportLogger.LOGGER.tracef("The resource %s is not a file %n", inputResource);
                if (inputResource.startsWith("[") && inputResource.endsWith("]")) {
                    inputStream = new ByteArrayInputStream(inputResource.getBytes());
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ItemReaderWriterBase.class.getClassLoader();
                }
                inputStream = cl.getResourceAsStream(inputResource);
            }
            if (detectBOM) {
                UnicodeBOMInputStream bomin = new UnicodeBOMInputStream(inputStream);
                bomin.skipBOM();
                return bomin;
            }
        }
        catch (IOException e) {
            throw SupportMessages.MESSAGES.failToOpenStream(e, inputResource);
        }
        return inputStream;
    }

    protected OutputStream getOutputStream(String writeMode) {
        if (this.resource == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "resource");
        }
        try {
            File file = new File(this.resource);
            boolean exists = file.exists();
            if (writeMode == null || writeMode.equalsIgnoreCase("append")) {
                return this.newFileOutputStream(file, exists, true, false);
            }
            if (writeMode.equalsIgnoreCase("overwrite")) {
                return this.newFileOutputStream(file, exists, false, false);
            }
            if (writeMode.equalsIgnoreCase("failIfExists")) {
                if (exists) {
                    throw SupportMessages.MESSAGES.writerResourceAlreadyExists(this.resource);
                }
                return this.newFileOutputStream(file, false, false, false);
            }
            if (writeMode.startsWith("failIfDirsNotExist")) {
                return this.newFileOutputStream(file, exists, !writeMode.endsWith("overwrite"), true);
            }
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, writeMode, "writeMode");
        }
        catch (IOException e) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(e, this.resource, "resource");
        }
    }

    private FileOutputStream newFileOutputStream(File file, boolean exists, boolean append, boolean failIfDirsNotExist) throws IOException {
        if (!exists) {
            File parentFile = file.getAbsoluteFile().getParentFile();
            if (parentFile == null) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.resource, "resource");
            }
            if (!parentFile.exists()) {
                if (failIfDirsNotExist) {
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.resource, "resource");
                }
                if (!parentFile.mkdirs()) {
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.resource, "resource");
                }
            }
        }
        FileOutputStream fos = new FileOutputStream(file, append);
        if (append && file.length() > 0L) {
            this.skipWritingHeader = true;
            fos.write(NEW_LINE.getBytes());
        }
        return fos;
    }

    static /* synthetic */ Validator access$000() {
        return ItemReaderWriterBase.getValidator0();
    }

    private static class Holder {
        private static final Validator validator = ItemReaderWriterBase.access$000();

        private Holder() {
        }
    }
}

