/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.jberet.support.io.JsonItemReaderWriterBase;

public abstract class JacksonCsvItemReaderWriterBase
extends JsonItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected String columns;
    @Inject
    @BatchProperty
    protected boolean useHeader;
    @Inject
    @BatchProperty
    protected String quoteChar;
    @Inject
    @BatchProperty
    protected String columnSeparator;
    @Inject
    @BatchProperty
    protected String nullValue;
    protected CsvMapper csvMapper;

    protected void init() throws Exception {
        this.initJsonFactoryAndObjectMapper();
        this.csvMapper = (CsvMapper)this.objectMapper;
    }

    @Override
    protected void initJsonFactory() throws Exception {
        this.jsonFactory = this.jsonFactoryLookup != null ? (JsonFactory)InitialContext.doLookup(this.jsonFactoryLookup) : new CsvFactory((ObjectCodec)new CsvMapper());
    }

    protected CsvSchema buildCsvSchema(CsvSchema schema) throws Exception {
        if (schema == null) {
            this.columns = this.columns.trim();
            if (this.columns.indexOf(44) < 0 && this.columns.indexOf(32) < 0) {
                schema = this.csvMapper.schemaFor(this.getClass().getClassLoader().loadClass(this.columns));
            } else {
                String[] cols = this.columns.split(",");
                CsvSchema.Builder builder = new CsvSchema.Builder();
                for (String e : cols) {
                    int lastSpace = (e = e.trim()).lastIndexOf(32);
                    if (lastSpace > 0) {
                        String e1 = e.substring(0, lastSpace).trim();
                        String e2 = e.substring(lastSpace + 1);
                        builder.addColumn(e1, CsvSchema.ColumnType.valueOf((String)e2));
                        continue;
                    }
                    builder.addColumn(e);
                }
                schema = builder.build();
            }
        }
        CsvSchema csvSchema = schema = this.useHeader ? schema.withHeader() : schema.withoutHeader();
        if (this.columnSeparator != null) {
            schema = schema.withColumnSeparator(this.columnSeparator.charAt(0));
        }
        if (this.quoteChar != null) {
            CsvSchema csvSchema2 = schema = this.quoteChar.equals("-1") ? schema.withoutQuoteChar() : schema.withQuoteChar(this.quoteChar.charAt(0));
        }
        if (this.nullValue != null) {
            schema = schema.withNullValue(this.nullValue);
        }
        return schema.withComments();
    }
}

