/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.Query;
import org.jberet.support.io.JpaItemReaderWriterBase;

@Named
@Dependent
public class JpaItemReader
extends JpaItemReaderWriterBase
implements ItemReader {
    @Inject
    protected Instance<Query> queryInstance;
    @Inject
    @BatchProperty
    protected String jpqlQuery;
    @Inject
    @BatchProperty
    protected String namedQuery;
    @Inject
    @BatchProperty
    protected String nativeQuery;
    @Inject
    @BatchProperty
    protected String storedProcedureQuery;
    @Inject
    @BatchProperty
    protected String namedStoredProcedureQuery;
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected String resultSetMapping;
    @Inject
    @BatchProperty
    protected Map<String, String> hints;
    @Inject
    @BatchProperty
    protected int firstResult;
    @Inject
    @BatchProperty
    protected int maxResults;
    protected Query query;
    protected List<?> resultList;
    protected int readPosition;

    public void open(Serializable checkpoint) throws Exception {
        this.query = this.getQuery();
        if (this.firstResult != 0) {
            this.query.setFirstResult(this.firstResult);
        }
        if (this.maxResults != 0) {
            this.query.setMaxResults(this.maxResults);
        }
        this.resultList = this.query.getResultList();
        this.readPosition = checkpoint == null ? 0 : (Integer)checkpoint;
    }

    public void close() throws Exception {
    }

    public Object readItem() throws Exception {
        if (this.readPosition >= this.resultList.size()) {
            return null;
        }
        return this.resultList.get(this.readPosition++);
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.readPosition);
    }

    protected Query getQuery() {
        Query q = null;
        if (this.queryInstance != null && !this.queryInstance.isUnsatisfied()) {
            q = (Query)this.queryInstance.get();
        }
        if (q == null) {
            if (this.jpqlQuery != null) {
                q = this.beanType != null ? this.em.createQuery(this.jpqlQuery, this.beanType) : this.em.createQuery(this.jpqlQuery);
            } else if (this.namedQuery != null) {
                q = this.beanType != null ? this.em.createNamedQuery(this.namedQuery, this.beanType) : this.em.createNamedQuery(this.namedQuery);
            } else if (this.nativeQuery != null) {
                q = this.beanType != null ? this.em.createNativeQuery(this.nativeQuery, this.beanType) : (this.resultSetMapping != null ? this.em.createNativeQuery(this.nativeQuery, this.resultSetMapping) : this.em.createNativeQuery(this.nativeQuery));
            } else if (this.storedProcedureQuery != null) {
                q = this.beanType != null ? this.em.createStoredProcedureQuery(this.storedProcedureQuery, new Class[]{this.beanType}) : (this.resultSetMapping != null ? this.em.createStoredProcedureQuery(this.storedProcedureQuery, new String[]{this.resultSetMapping}) : this.em.createStoredProcedureQuery(this.storedProcedureQuery));
            } else if (this.namedStoredProcedureQuery != null) {
                q = this.em.createNamedStoredProcedureQuery(this.namedStoredProcedureQuery);
            }
        }
        if (this.firstResult != 0) {
            q.setFirstResult(this.firstResult);
        }
        if (this.maxResults != 0) {
            q.setMaxResults(this.maxResults);
        }
        if (this.hints != null) {
            for (Map.Entry<String, String> e : this.hints.entrySet()) {
                q.setHint(e.getKey(), (Object)e.getValue());
            }
        }
        return q;
    }
}

