/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;

public final class MongoClientObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String uri = (String)environment.get("uri");
        MongoClientURI clientURI = uri != null ? new MongoClientURI(uri) : MongoClientObjectFactory.createMongoClientURI((String)environment.get("host"), (String)environment.get("database"), (String)environment.get("collection"), (String)environment.get("options"), (String)environment.get("user"), (String)environment.get("password"));
        MongoClient mongoClient = (MongoClient)Mongo.Holder.singleton().connect(clientURI);
        SupportLogger.LOGGER.tracef("getObjectInstance obtained MongoClient %s with uri %s%n", mongoClient, clientURI);
        return mongoClient;
    }

    static MongoClientURI createMongoClientURI(String host, String database, String collection, String options, String user, String password) throws Exception {
        if (host == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "host");
        }
        StringBuilder uriVal = new StringBuilder("mongodb://");
        if (user != null) {
            uriVal.append(user).append(':').append(password == null ? "" : password).append('@');
        }
        uriVal.append(host).append('/');
        if (database != null) {
            uriVal.append(database);
            if (collection != null) {
                uriVal.append('.').append(collection);
            }
        }
        if (options != null) {
            uriVal.append('?').append(options);
        }
        return new MongoClientURI(uriVal.toString());
    }
}

