/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.client.WebTarget;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.RestItemReaderWriterBase;

@Named
@Dependent
public class RestItemReader
extends RestItemReaderWriterBase
implements ItemReader {
    public static final String DEFAULT_OFFSET_KEY = "offset";
    public static final String DEFAULT_OFFSET = "0";
    public static final String DEFAULT_LIMIT_KEY = "limit";
    public static final String DEFAULT_LIMIT = "10";
    @Inject
    @BatchProperty
    protected String offsetKey;
    @Inject
    @BatchProperty
    protected String offset;
    @Inject
    @BatchProperty
    protected String limitKey;
    @Inject
    @BatchProperty
    protected String limit;
    @Inject
    @BatchProperty
    protected Class beanType;
    protected Class entityType;
    protected int readerPosition;
    protected List<Object> recordsBuffer = new ArrayList<Object>();

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        if (this.httpMethod == null) {
            this.httpMethod = "GET";
        } else {
            this.httpMethod = this.httpMethod.toUpperCase(Locale.ENGLISH);
            if (!"GET".equals(this.httpMethod) && !"DELETE".equals(this.httpMethod)) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.httpMethod, "httpMethod");
            }
        }
        if (this.offsetKey == null) {
            this.offsetKey = DEFAULT_OFFSET_KEY;
        }
        if (this.offset == null) {
            this.offset = DEFAULT_OFFSET;
        }
        this.readerPosition = checkpoint != null ? (Integer)checkpoint : Integer.parseInt(this.offset) - 1;
        if (this.limitKey == null) {
            this.limitKey = DEFAULT_LIMIT_KEY;
        }
        if (this.limit == null) {
            this.limit = DEFAULT_LIMIT;
        }
        this.entityType = this.beanType == null ? Object[].class : Array.newInstance(this.beanType, 0).getClass();
    }

    public Serializable checkpointInfo() {
        return Integer.valueOf(this.readerPosition);
    }

    public Object readItem() throws Exception {
        Object[] recordsArray;
        int size = this.recordsBuffer.size();
        ++this.readerPosition;
        if (size > 0) {
            return this.recordsBuffer.remove(size - 1);
        }
        WebTarget target = this.client.target(this.restUrl).queryParam(this.offsetKey, new Object[]{this.readerPosition}).queryParam(this.limitKey, new Object[]{this.limit});
        Object[] objectArray = recordsArray = "GET".equals(this.httpMethod) ? (Object[])target.request().get(this.entityType) : (Object[])target.request().delete(this.entityType);
        if (recordsArray.length == 0) {
            return null;
        }
        for (int i = recordsArray.length - 1; i > 0; --i) {
            this.recordsBuffer.add(recordsArray[i]);
        }
        return recordsArray[0];
    }

    @Override
    public void close() {
        super.close();
        this.recordsBuffer.clear();
    }
}

