/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.JsonItemReader;

@Named
@Dependent
public class ArrayItemReader
extends JsonItemReader {
    private Object[] values;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        if (this.beanType == null) {
            this.beanType = String.class;
        }
        Object[] objs = (Object[])Array.newInstance(this.beanType, 0);
        Object inputSource = this.jsonParser.getInputSource();
        this.values = inputSource instanceof ByteArrayInputStream ? (Object[])this.objectMapper.readValue(this.resource, objs.getClass()) : (Object[])this.objectMapper.readValue(this.jsonParser, objs.getClass());
        if (checkpoint == null) {
            while (this.start > 0 && this.rowNumber < this.start) {
                ++this.rowNumber;
            }
        } else {
            this.rowNumber = (Integer)checkpoint;
        }
    }

    @Override
    public Object readItem() throws Exception {
        if (this.values == null || this.rowNumber >= this.values.length || this.rowNumber > this.end) {
            return null;
        }
        Object obj = this.values[this.rowNumber++];
        SupportLogger.LOGGER.tracef("Read type %s, value %s%n", obj.getClass(), obj);
        return obj;
    }
}

