/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.CellProcessorConfig;
import org.jberet.support.io.ItemReaderWriterBase;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentMatches;
import org.supercsv.comment.CommentStartsWith;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.encoder.SelectiveCsvEncoder;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.quote.AlwaysQuoteMode;
import org.supercsv.quote.ColumnQuoteMode;
import org.supercsv.quote.QuoteMode;

public abstract class CsvItemReaderWriterBase
extends ItemReaderWriterBase {
    static final Class<?>[] stringParameterTypes = new Class[]{String.class};
    static final CellProcessor[] noCellProcessors = new CellProcessor[0];
    @Inject
    @BatchProperty
    protected String[] nameMapping;
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected String preference;
    @Inject
    @BatchProperty
    protected String quoteChar;
    @Inject
    @BatchProperty
    protected String delimiterChar;
    @Inject
    @BatchProperty
    protected String endOfLineSymbols;
    @Inject
    @BatchProperty
    protected String surroundingSpacesNeedQuotes;
    @Inject
    @BatchProperty
    protected String commentMatcher;
    @Inject
    @BatchProperty
    protected String encoder;
    @Inject
    @BatchProperty
    protected String quoteMode;
    @Inject
    @BatchProperty
    protected String cellProcessors;
    @Inject
    @BatchProperty
    protected String charset;
    protected CellProcessor[] cellProcessorInstances;

    protected CsvPreference getCsvPreference() {
        CsvPreference csvPreference;
        if (this.preference == null || "STANDARD_PREFERENCE".equals(this.preference)) {
            csvPreference = CsvPreference.STANDARD_PREFERENCE;
        } else if ("EXCEL_PREFERENCE".equals(this.preference)) {
            csvPreference = CsvPreference.EXCEL_PREFERENCE;
        } else if ("EXCEL_NORTH_EUROPE_PREFERENCE".equals(this.preference)) {
            csvPreference = CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;
        } else if ("TAB_PREFERENCE".equals(this.preference)) {
            csvPreference = CsvPreference.TAB_PREFERENCE;
        } else {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.preference, "preference");
        }
        if (this.quoteChar != null || this.delimiterChar != null || this.endOfLineSymbols != null || this.surroundingSpacesNeedQuotes != null || this.commentMatcher != null || this.encoder != null || this.quoteMode != null) {
            QuoteMode quoteMode1;
            CsvEncoder encoder1;
            CsvPreference.Builder builder = new CsvPreference.Builder(this.quoteChar == null ? csvPreference.getQuoteChar() : this.quoteChar.charAt(0), this.delimiterChar == null ? csvPreference.getDelimiterChar() : (int)this.delimiterChar.charAt(0), this.endOfLineSymbols == null ? csvPreference.getEndOfLineSymbols() : this.endOfLineSymbols.trim());
            if (this.surroundingSpacesNeedQuotes != null) {
                builder.surroundingSpacesNeedQuotes(Boolean.parseBoolean(this.surroundingSpacesNeedQuotes.trim()));
            }
            if (this.commentMatcher != null) {
                builder.skipComments(this.getCommentMatcher(this.commentMatcher));
            }
            if (this.encoder != null && (encoder1 = this.getEncoder(this.encoder)) != null) {
                builder.useEncoder(encoder1);
            }
            if (this.quoteMode != null && (quoteMode1 = this.getQuoteMode(this.quoteMode)) != null) {
                builder.useQuoteMode(quoteMode1);
            }
            csvPreference = builder.build();
        }
        return csvPreference;
    }

    protected CellProcessor[] getCellProcessors() {
        if (this.cellProcessors == null) {
            return noCellProcessors;
        }
        return CellProcessorConfig.parseCellProcessors(this.cellProcessors.trim());
    }

    protected String[] getNameMapping() {
        return this.nameMapping;
    }

    protected QuoteMode getQuoteMode(String val) {
        String[] parts = val.split("[,\\s]+");
        if (parts.length == 1) {
            String quoteModeName = parts[0];
            if (quoteModeName.equalsIgnoreCase("default")) {
                return null;
            }
            if (quoteModeName.equalsIgnoreCase("always")) {
                return new AlwaysQuoteMode();
            }
            return (QuoteMode)CsvItemReaderWriterBase.loadAndInstantiate(quoteModeName, val, null);
        }
        String quoteModeName = parts[0];
        String encoderNameLowerCase = quoteModeName.toLowerCase();
        if (encoderNameLowerCase.startsWith("select") || encoderNameLowerCase.startsWith("column")) {
            try {
                Integer.parseInt(parts[1]);
                return new ColumnQuoteMode(CsvItemReaderWriterBase.convertToIntParams(parts, 1, parts.length - 1));
            }
            catch (NumberFormatException e) {
                return new ColumnQuoteMode(CsvItemReaderWriterBase.convertToBooleanParams(parts));
            }
        }
        throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, val, "encoder");
    }

    protected CsvEncoder getEncoder(String val) {
        String[] parts = val.split("[,\\s]+");
        if (parts.length == 1) {
            String encoderName = parts[0];
            if (encoderName.equalsIgnoreCase("default")) {
                return null;
            }
            return (CsvEncoder)CsvItemReaderWriterBase.loadAndInstantiate(encoderName, val, null);
        }
        String encoderName = parts[0];
        String encoderNameLowerCase = encoderName.toLowerCase();
        if (encoderNameLowerCase.startsWith("select") || encoderNameLowerCase.startsWith("column")) {
            try {
                Integer.parseInt(parts[1]);
                return new SelectiveCsvEncoder(CsvItemReaderWriterBase.convertToIntParams(parts, 1, parts.length - 1));
            }
            catch (NumberFormatException e) {
                return new SelectiveCsvEncoder(CsvItemReaderWriterBase.convertToBooleanParams(parts));
            }
        }
        throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, val, "encoder");
    }

    protected CommentMatcher getCommentMatcher(String val) {
        CommentStartsWith commentMatcher;
        val = val.trim();
        int paramQuoteChar = 39;
        int singleQuote1 = val.indexOf(39);
        String matcherName = null;
        String matcherParam = null;
        if (singleQuote1 < 0) {
            String[] parts = val.split("\\s");
            if (parts.length == 1) {
                return (CommentMatcher)CsvItemReaderWriterBase.loadAndInstantiate(parts[0], val, null);
            }
            if (parts.length == 2) {
                matcherName = parts[0];
                matcherParam = parts[1];
            } else {
                throw SupportMessages.MESSAGES.missingQuote(val);
            }
        }
        if (matcherName == null) {
            matcherName = val.substring(0, singleQuote1 - 1).trim();
            int paramQuoteCharEnd = val.lastIndexOf(39);
            matcherParam = val.substring(singleQuote1 + 1, paramQuoteCharEnd);
            matcherName = matcherName.split("\\s")[0];
        }
        if (matcherName.equalsIgnoreCase("startsWith") || matcherName.equalsIgnoreCase("starts") || matcherName.equalsIgnoreCase("start")) {
            commentMatcher = new CommentStartsWith(matcherParam);
        } else if (matcherName.equalsIgnoreCase("matches") || matcherName.equalsIgnoreCase("match")) {
            commentMatcher = new CommentMatches(matcherParam);
        } else {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, val, "commentMatcher");
        }
        return commentMatcher;
    }

    private static <T> T loadAndInstantiate(String className, String contextVal, String param) {
        try {
            Class<?> aClass = CsvItemReaderWriterBase.class.getClassLoader().loadClass(className);
            if (param == null) {
                return (T)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Constructor<?> constructor = aClass.getConstructor(stringParameterTypes);
            return (T)constructor.newInstance(param);
        }
        catch (Exception e) {
            throw SupportMessages.MESSAGES.failToLoadOrCreateCustomType(e, contextVal);
        }
    }

    static int[] convertToIntParams(String[] strings, int start, int count) {
        int[] ints = new int[count];
        int i = start;
        for (int j = 0; j < count && i < strings.length; ++i, ++j) {
            ints[j] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    private static boolean[] convertToBooleanParams(String[] strings) {
        boolean[] booleans = new boolean[strings.length - 1];
        for (int i = 1; i < strings.length; ++i) {
            booleans[i - 1] = Boolean.parseBoolean(strings[i]);
        }
        return booleans;
    }
}

