/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.CsvItemReaderWriterBase;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.io.CsvListWriter;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.io.ICsvBeanWriter;
import org.supercsv.io.ICsvListWriter;
import org.supercsv.io.ICsvMapWriter;
import org.supercsv.io.ICsvWriter;

@Named
@Dependent
public class CsvItemWriter
extends CsvItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String[] header;
    @Inject
    @BatchProperty
    protected String writeComments;
    @Inject
    @BatchProperty
    protected String writeMode;
    protected ICsvWriter delegateWriter;

    public void open(Serializable checkpoint) throws Exception {
        OutputStreamWriter writer;
        SupportLogger.LOGGER.tracef("Open CsvItemWriter with checkpoint %s, which is ignored for CsvItemWriter.%n", checkpoint);
        if (this.beanType == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "beanType");
        }
        OutputStream outputStream = this.getOutputStream(this.writeMode);
        OutputStreamWriter outputStreamWriter = writer = this.charset == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, this.charset);
        this.delegateWriter = List.class.isAssignableFrom(this.beanType) ? new CsvListWriter((Writer)writer, this.getCsvPreference()) : (Map.class.isAssignableFrom(this.beanType) ? new CsvMapWriter((Writer)writer, this.getCsvPreference()) : new CsvBeanWriter((Writer)writer, this.getCsvPreference()));
        if (this.header == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "header");
        }
        if (this.nameMapping == null) {
            this.nameMapping = this.header;
        }
        SupportLogger.LOGGER.openingResource(this.resource, this.getClass());
        this.cellProcessorInstances = this.getCellProcessors();
        if (this.writeComments != null) {
            this.delegateWriter.writeComment(this.writeComments);
        }
        if (!this.skipWritingHeader) {
            this.delegateWriter.writeHeader(this.header);
        }
    }

    public void close() throws Exception {
        if (this.delegateWriter != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            this.delegateWriter.close();
            this.delegateWriter = null;
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        if (SupportLogger.LOGGER.isTraceEnabled()) {
            SupportLogger.LOGGER.tracef("About to write items, number of items %s, element type %s%n", items.size(), items.get(0).getClass());
        }
        if (this.delegateWriter instanceof ICsvBeanWriter) {
            ICsvBeanWriter writer = (ICsvBeanWriter)this.delegateWriter;
            if (this.cellProcessorInstances.length == 0) {
                for (Object e : items) {
                    writer.write(e, this.nameMapping);
                }
            } else {
                for (Object e : items) {
                    writer.write(e, this.nameMapping, this.cellProcessorInstances);
                }
            }
        } else if (this.delegateWriter instanceof ICsvMapWriter) {
            ICsvMapWriter writer = (ICsvMapWriter)this.delegateWriter;
            if (this.cellProcessorInstances.length == 0) {
                for (Object e : items) {
                    writer.write((Map)e, this.nameMapping);
                }
            } else {
                for (Object e : items) {
                    writer.write((Map)e, this.nameMapping, this.cellProcessorInstances);
                }
            }
        } else if (this.delegateWriter instanceof ICsvListWriter) {
            ICsvListWriter writer = (ICsvListWriter)this.delegateWriter;
            if (this.cellProcessorInstances.length == 0) {
                for (Object e : items) {
                    List asList = (List)e;
                    if (asList.size() <= 0) continue;
                    writer.write(asList);
                }
            } else {
                for (Object e : items) {
                    List asList = (List)e;
                    if (asList.size() <= 0) continue;
                    writer.write(asList, this.cellProcessorInstances);
                }
            }
        }
        this.delegateWriter.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.delegateWriter.getRowNumber());
    }
}

