/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jberet.support.io.DynamoDbItemReadWriterBase;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbIndex;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@Named
@Dependent
public class DynamoDbItemReader<D>
extends DynamoDbItemReadWriterBase<D>
implements ItemReader {
    @Inject
    @BatchProperty
    protected String indexName;
    @Inject
    @BatchProperty
    protected String partitionKey;
    @Inject
    @BatchProperty
    protected Boolean consistentRead;
    @Inject
    @BatchProperty
    protected Integer start;
    @Inject
    @BatchProperty
    protected Integer end;
    @Inject
    @BatchProperty
    protected Integer limit;
    @Inject
    @BatchProperty
    protected String filterExpression;
    @Inject
    @BatchProperty
    protected String filterExpressionNames;
    @Inject
    @BatchProperty
    protected String filterExpressionValues;
    @Inject
    @BatchProperty
    protected String attributesToProject;
    private Iterator<D> itemIterator;

    public void open(Serializable serializable) throws Exception {
        this.initEnhancedClient();
        PageIterable pageIterable = this.read(this.getTable());
        Stream itemStream = pageIterable.items().stream();
        if (this.start != null && this.start >= 0) {
            itemStream = itemStream.skip(this.start.intValue());
        }
        if (this.end != null && this.end > 0) {
            itemStream = itemStream.limit(this.end - (this.start == null ? 0 : this.start));
        }
        this.itemIterator = itemStream.iterator();
    }

    private PageIterable<D> read(DynamoDbTable<D> table) {
        PageIterable pageIterable;
        Key queryKey = this.getQueryKey();
        if (this.indexName == null) {
            pageIterable = queryKey == null ? table.scan(this::configureScanRequest) : table.query(builder -> this.configureQueryRequest((QueryEnhancedRequest.Builder)builder, queryKey));
        } else {
            DynamoDbIndex index = table.index(this.indexName);
            pageIterable = queryKey == null ? PageIterable.create((SdkIterable)index.scan(this::configureScanRequest)) : PageIterable.create((SdkIterable)index.query(builder -> this.configureQueryRequest((QueryEnhancedRequest.Builder)builder, queryKey)));
        }
        return pageIterable;
    }

    private QueryEnhancedRequest.Builder configureQueryRequest(QueryEnhancedRequest.Builder builder, Key queryKey) {
        return builder.consistentRead(this.consistentRead).limit(this.limit).queryConditional(QueryConditional.keyEqualTo((Key)queryKey)).filterExpression(this.getFilterExpression());
    }

    private ScanEnhancedRequest.Builder configureScanRequest(ScanEnhancedRequest.Builder builder) {
        return builder.consistentRead(this.consistentRead).limit(this.limit).filterExpression(this.getFilterExpression()).attributesToProject(this.getAttributesToProject());
    }

    public void close() throws Exception {
    }

    public D readItem() {
        return this.itemIterator.hasNext() ? (D)this.itemIterator.next() : null;
    }

    private Expression getFilterExpression() {
        if (this.filterExpression == null) {
            return null;
        }
        return Expression.builder().expression(this.filterExpression).expressionNames(this.getFilterExpressionNames()).expressionValues(this.getFilterExpressionValues()).build();
    }

    protected Map<String, String> getFilterExpressionNames() {
        if (this.filterExpressionNames == null) {
            return null;
        }
        try {
            return (Map)new ObjectMapper().readValue(this.filterExpressionNames, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid filterExpressionNames JSON", e);
        }
    }

    protected Map<String, AttributeValue> getFilterExpressionValues() {
        if (this.filterExpressionValues == null) {
            return Collections.emptyMap();
        }
        try {
            ObjectNode objectNode = (ObjectNode)new ObjectMapper().readTree(this.filterExpressionValues);
            return DynamoDbItemReader.getAttributeValues(objectNode);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid filterExpressionValues JSON", e);
        }
    }

    static Map<String, AttributeValue> getAttributeValues(ObjectNode objectNode) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>(objectNode.size());
        Iterator fieldIter = objectNode.fields();
        while (fieldIter.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIter.next();
            map.put((String)field.getKey(), DynamoDbItemReader.getAttributeValue((JsonNode)field.getValue()));
        }
        return map;
    }

    private static List<AttributeValue> getAttributeValues(ArrayNode arrayNode) {
        ArrayList<AttributeValue> list = new ArrayList<AttributeValue>(arrayNode.size());
        for (JsonNode item : arrayNode) {
            list.add(DynamoDbItemReader.getAttributeValue(item));
        }
        return list;
    }

    private static AttributeValue getAttributeValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return AttributeValue.fromNul((Boolean)true);
        }
        if (node.isTextual()) {
            return AttributeValue.fromS((String)node.textValue());
        }
        if (node.isNumber()) {
            return AttributeValue.fromN((String)node.toString());
        }
        if (node.isBoolean()) {
            return AttributeValue.fromBool((Boolean)node.booleanValue());
        }
        if (node.isArray()) {
            return AttributeValue.fromL(DynamoDbItemReader.getAttributeValues((ArrayNode)node));
        }
        if (node.isObject()) {
            return AttributeValue.fromM(DynamoDbItemReader.getAttributeValues((ObjectNode)node));
        }
        return null;
    }

    private Collection<String> getAttributesToProject() {
        if (this.attributesToProject == null) {
            return null;
        }
        return Stream.of(this.attributesToProject.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private Key getQueryKey() {
        if (this.partitionKey == null) {
            return null;
        }
        return Key.builder().partitionValue(this.partitionKey).build();
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

