/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jberet.support.io.DynamoDbItemReadWriterBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchWriteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.BatchWriteResult;
import software.amazon.awssdk.enhanced.dynamodb.model.WriteBatch;

@Named
@Dependent
public class DynamoDbItemWriter<D>
extends DynamoDbItemReadWriterBase<D>
implements ItemWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @BatchProperty
    protected boolean deleteItem;

    protected void addItemToBatch(Object item, WriteBatch.Builder<D> writeBatch) {
        Object typedItem = this.beanClass.cast(item);
        if (this.shouldDeleteItem(typedItem)) {
            writeBatch.addDeleteItem(typedItem);
        } else {
            writeBatch.addPutItem(typedItem);
        }
    }

    protected boolean shouldDeleteItem(D item) {
        return this.deleteItem;
    }

    public void open(Serializable serializable) {
        this.initEnhancedClient();
    }

    public void writeItems(List<Object> items) {
        InternalWriteBatch batch = new InternalWriteBatch();
        items.forEach(batch::addItem);
        batch.flush();
        if (!batch.unprocessedPutItems.isEmpty()) {
            this.handleUnprocessedPutItems(batch.unprocessedPutItems);
        }
        if (!batch.unprocessedDeleteItems.isEmpty()) {
            this.handleUnprocessedDeleteItems(batch.unprocessedDeleteItems);
        }
    }

    protected void handleUnprocessedDeleteItems(List<Key> unprocessedDeleteItems) {
        this.logger.warn("{} unprocessed delete items", (Object)unprocessedDeleteItems.size());
    }

    protected void handleUnprocessedPutItems(List<D> unprocessedPutItems) {
        this.logger.warn("{} unprocessed put items", (Object)unprocessedPutItems.size());
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    public void close() throws Exception {
    }

    private class InternalWriteBatch {
        private final DynamoDbTable<D> table;
        private WriteBatch.Builder<D> batchBuilder;
        private int batchSize;
        private final List<D> unprocessedPutItems = new ArrayList();
        private final List<Key> unprocessedDeleteItems = new ArrayList<Key>();

        private InternalWriteBatch() {
            this.table = DynamoDbItemWriter.this.getTable();
            this.newBatch();
        }

        private void newBatch() {
            this.batchBuilder = WriteBatch.builder((Class)DynamoDbItemWriter.this.beanClass).mappedTableResource(this.table);
            this.batchSize = 0;
        }

        void addItem(Object item) {
            DynamoDbItemWriter.this.addItemToBatch(item, this.batchBuilder);
            ++this.batchSize;
            if (this.batchSize == 25) {
                this.flush();
            }
        }

        void flush() {
            if (this.batchSize == 0) {
                return;
            }
            BatchWriteResult batchWriteResult = DynamoDbItemWriter.this.enhancedClient.batchWriteItem(BatchWriteItemEnhancedRequest.builder().addWriteBatch(this.batchBuilder.build()).build());
            this.unprocessedPutItems.addAll(batchWriteResult.unprocessedPutItemsForTable(this.table));
            this.unprocessedDeleteItems.addAll(batchWriteResult.unprocessedDeleteItemsForTable(this.table));
            this.newBatch();
        }
    }
}

