/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvReflectionException;
import org.supercsv.io.AbstractCsvReader;
import org.supercsv.io.ICsvBeanReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.BeanInterfaceProxy;
import org.supercsv.util.MethodCache;

final class FastForwardCsvBeanReader
extends AbstractCsvReader
implements ICsvBeanReader {
    private final List<Object> processedColumns = new ArrayList<Object>();
    private final MethodCache cache = new MethodCache();
    private final int startRowNumber;

    FastForwardCsvBeanReader(Reader reader, CsvPreference preferences, int startRowNumber) {
        super(reader, preferences);
        this.startRowNumber = startRowNumber;
    }

    private static <T> T instantiateBean(Class<T> clazz) {
        Object bean;
        if (clazz.isInterface()) {
            bean = BeanInterfaceProxy.createProxy(clazz);
        } else {
            try {
                bean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new SuperCsvReflectionException(String.format("error instantiating bean, check that %s has a default no-args constructor", clazz.getName()), (Throwable)e);
            }
            catch (Exception e) {
                throw new SuperCsvReflectionException("error instantiating bean", (Throwable)e);
            }
        }
        return (T)bean;
    }

    private static void invokeSetter(Object bean, Method setMethod, Object fieldValue) {
        try {
            setMethod.invoke(bean, fieldValue);
        }
        catch (Exception e) {
            throw new SuperCsvReflectionException(String.format("error invoking method %s()", setMethod.getName()), (Throwable)e);
        }
    }

    private <T> T populateBean(Class<T> clazz, String[] nameMapping) {
        T resultBean = FastForwardCsvBeanReader.instantiateBean(clazz);
        for (int i = 0; i < nameMapping.length; ++i) {
            Object fieldValue = this.processedColumns.get(i);
            if (nameMapping[i] == null || fieldValue == null) continue;
            Method setMethod = this.cache.getSetMethod(resultBean, nameMapping[i], fieldValue.getClass());
            FastForwardCsvBeanReader.invokeSetter(resultBean, setMethod, fieldValue);
        }
        return resultBean;
    }

    public <T> T read(Class<T> clazz, String ... nameMapping) throws IOException {
        this.fastForwardToStartRow();
        if (this.readRow()) {
            if (nameMapping.length != this.length()) {
                throw new IllegalArgumentException(String.format("the nameMapping array and the number of columns read should be the same size (nameMapping length = %d, columns = %d)", nameMapping.length, this.length()));
            }
            this.processedColumns.clear();
            this.processedColumns.addAll(this.getColumns());
            return this.populateBean(clazz, nameMapping);
        }
        return null;
    }

    public <T> T read(Class<T> clazz, String[] nameMapping, CellProcessor ... processors) throws IOException {
        this.fastForwardToStartRow();
        if (this.readRow()) {
            this.executeProcessors(this.processedColumns, processors);
            return this.populateBean(clazz, nameMapping);
        }
        return null;
    }

    public <T> T read(T t, String ... strings) throws IOException {
        return null;
    }

    public <T> T read(T t, String[] strings, CellProcessor ... cellProcessors) throws IOException {
        return null;
    }

    private void fastForwardToStartRow() throws IOException {
        while (this.getRowNumber() < this.startRowNumber) {
            this.readRow();
        }
    }
}

