/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemReader;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.JdbcItemReaderWriterBase;

@Named
@Dependent
public class JdbcItemReader
extends JdbcItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected String[] columnMapping;
    @Inject
    @BatchProperty
    protected String[] columnTypes;
    @Inject
    @BatchProperty
    protected Map<String, String> resultSetProperties;
    @Inject
    @BatchProperty
    protected Boolean autoCommit;
    protected String[] columnLabels;
    protected Connection connection;
    protected ResultSet resultSet;
    protected int currentRowNumber;

    public void open(Serializable checkpoint) throws Exception {
        int checkpointPosition;
        this.init();
        this.connection = this.getConnection();
        if (this.autoCommit != null) {
            this.connection.setAutoCommit(this.autoCommit);
        }
        int[] rsProps = this.parseResultSetProperties();
        if (this.isStoredProcedure()) {
            this.preparedStatement = this.connection.prepareCall(this.sql, rsProps[0], rsProps[1], rsProps[2]);
            this.preparedStatement.setFetchDirection(rsProps[3]);
            this.preparedStatement.setFetchSize(rsProps[4]);
            this.resultSet = this.executeStoredProcedure();
        } else {
            this.preparedStatement = this.connection.prepareStatement(this.sql, rsProps[0], rsProps[1], rsProps[2]);
            this.preparedStatement.setFetchDirection(rsProps[3]);
            this.preparedStatement.setFetchSize(rsProps[4]);
            this.resultSet = this.preparedStatement.executeQuery();
        }
        if (this.columnMapping == null) {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            if (this.columnTypes != null && this.columnTypes.length != columnCount) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, Arrays.toString(this.columnTypes), "columnTypes");
            }
            this.columnLabels = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                this.columnLabels[i] = metaData.getColumnLabel(i + 1);
            }
            this.columnMapping = this.columnLabels;
        }
        if (this.start <= 0) {
            this.start = 1;
        }
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (this.end < this.start) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, String.valueOf(this.end), "end");
        }
        int readyPosition = this.start - 1;
        if (checkpoint != null && (checkpointPosition = ((Integer)checkpoint).intValue()) > readyPosition) {
            readyPosition = checkpointPosition;
        }
        if (readyPosition >= 0) {
            this.resultSet.absolute(readyPosition);
        }
        this.currentRowNumber = readyPosition;
    }

    public void close() throws Exception {
        if (this.preparedStatement != null || this.connection != null || this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close ResultSet", new Object[0]);
            }
            JdbcItemReaderWriterBase.close(this.connection, this.preparedStatement);
            this.connection = null;
            this.preparedStatement = null;
            this.resultSet = null;
        }
    }

    public Object readItem() throws Exception {
        if (this.currentRowNumber >= this.end) {
            return null;
        }
        Object result = null;
        if (this.resultSet.next()) {
            if (this.beanType == List.class) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                for (int i = 0; i < this.columnMapping.length; ++i) {
                    resultList.add(this.getColumnValue(i));
                }
                result = resultList;
            } else {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                for (int i = 0; i < this.columnMapping.length; ++i) {
                    resultMap.put(this.columnMapping[i], this.getColumnValue(i));
                }
                if (this.beanType == Map.class) {
                    result = resultMap;
                } else {
                    Object readValue = this.objectMapper.convertValue(resultMap, this.beanType);
                    if (!this.skipBeanValidation) {
                        ItemReaderWriterBase.validate(readValue);
                    }
                    result = readValue;
                }
            }
            this.currentRowNumber = this.resultSet.getRow();
        }
        return result;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.currentRowNumber);
    }

    protected boolean isStoredProcedure() {
        this.sql = this.sql.trim();
        return this.sql.startsWith("{") && this.sql.endsWith("}");
    }

    protected int[] parseResultSetProperties() {
        int[] result = new int[5];
        int rsType = 0;
        int rsConcur = 1007;
        int rsHold = 1;
        int fetchDirection = 1000;
        int fetchSize = 0;
        if (this.resultSetProperties != null) {
            for (Map.Entry<String, String> e : this.resultSetProperties.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if ("fetchSize".equals(k)) {
                    fetchSize = Integer.parseInt(v.trim());
                    continue;
                }
                if ("resultSetType".equals(k)) {
                    if ("TYPE_FORWARD_ONLY".equals(v)) {
                        rsType = 1003;
                        continue;
                    }
                    if ("TYPE_SCROLL_SENSITIVE".equals(v)) {
                        rsType = 1005;
                        continue;
                    }
                    if ("TYPE_SCROLL_INSENSITIVE".equals(v)) {
                        rsType = 1004;
                        continue;
                    }
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, v, "resultSetType");
                }
                if ("resultSetConcurrency".equals(k)) {
                    if ("CONCUR_READ_ONLY".equals(v)) {
                        rsConcur = 1007;
                        continue;
                    }
                    if ("CONCUR_UPDATABLE".equals(v)) {
                        rsConcur = 1008;
                        continue;
                    }
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, v, "resultSetConcurrency");
                }
                if ("resultSetHoldability".equals(k)) {
                    if ("HOLD_CURSORS_OVER_COMMIT".equals(v)) {
                        rsHold = 1;
                        continue;
                    }
                    if ("CLOSE_CURSORS_AT_COMMIT".equals(v)) {
                        rsHold = 2;
                        continue;
                    }
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, v, "resultSetHoldability");
                }
                if ("fetchDirection".equals(k)) {
                    if ("FETCH_FORWARD".equals(v)) {
                        fetchDirection = 1000;
                        continue;
                    }
                    if ("FETCH_REVERSE".equals(v)) {
                        fetchDirection = 1001;
                        continue;
                    }
                    if ("FETCH_UNKNOWN".equals(v)) {
                        fetchDirection = 1002;
                        continue;
                    }
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, v, "fetchDirection");
                }
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, v, k);
            }
        }
        if (rsType == 0) {
            rsType = this.connection.getClass().getName().contains(".db2.") ? 1004 : 1003;
        }
        result[0] = rsType;
        result[1] = rsConcur;
        result[2] = rsHold;
        result[3] = fetchDirection;
        result[4] = fetchSize;
        return result;
    }

    protected ResultSet executeStoredProcedure() throws SQLException {
        boolean hasResultSet = this.preparedStatement.execute();
        ResultSet rs = hasResultSet ? this.preparedStatement.getResultSet() : null;
        return rs;
    }

    private Object getColumnValue(int i) throws Exception {
        Object val = null;
        int pos = i + 1;
        if (this.columnTypes == null) {
            val = this.resultSet.getObject(pos);
        } else {
            String type = this.columnTypes[i];
            if (type.equals("String")) {
                val = this.resultSet.getString(pos);
            } else if (type.equals("Date")) {
                val = this.resultSet.getDate(pos);
            } else if (type.equals("Timestamp")) {
                val = this.resultSet.getTimestamp(pos);
            } else if (type.equals("Time")) {
                val = this.resultSet.getTime(pos);
            } else if (type.equals("Object") || type.equals("null")) {
                val = this.resultSet.getObject(pos);
            } else if (type.equals("NString")) {
                val = this.resultSet.getNString(pos);
            } else if (type.equals("Boolean")) {
                val = this.resultSet.getBoolean(pos);
            } else if (type.equals("Int")) {
                val = this.resultSet.getInt(pos);
            } else if (type.equals("Long")) {
                val = this.resultSet.getLong(pos);
            } else if (type.equals("Double")) {
                val = this.resultSet.getDouble(pos);
            } else if (type.equals("Float")) {
                val = Float.valueOf(this.resultSet.getFloat(pos));
            } else if (type.equals("Short")) {
                val = this.resultSet.getShort(pos);
            } else if (type.equals("Byte")) {
                val = this.resultSet.getByte(pos);
            } else if (type.equals("Blob")) {
                val = this.resultSet.getBlob(pos);
            } else if (type.equals("Clob")) {
                val = this.resultSet.getClob(pos);
            } else if (type.equals("NClob")) {
                val = this.resultSet.getNClob(pos);
            } else if (type.equals("BigDecimal")) {
                val = this.resultSet.getBigDecimal(pos);
            } else if (type.equals("URL")) {
                val = this.resultSet.getURL(pos);
            } else if (type.equals("Bytes")) {
                val = this.resultSet.getBytes(pos);
            } else if (type.equals("BinaryStream")) {
                val = this.resultSet.getBinaryStream(pos);
            } else if (type.equals("CharacterStream")) {
                val = this.resultSet.getCharacterStream(pos);
            } else if (type.equals("NCharacterStream")) {
                val = this.resultSet.getNCharacterStream(pos);
            } else if (type.equals("AsciiStream")) {
                val = this.resultSet.getAsciiStream(pos);
            } else if (type.equals("Ref")) {
                val = this.resultSet.getRef(pos);
            } else if (type.equals("RowId")) {
                val = this.resultSet.getRowId(pos);
            } else if (type.equals("SQLXML")) {
                val = this.resultSet.getSQLXML(pos);
            } else if (type.equals("Array")) {
                val = this.resultSet.getArray(pos);
            }
            if (this.resultSet.wasNull()) {
                val = null;
            }
        }
        return val;
    }
}

