/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.io.Serializable;
import javax.naming.InitialContext;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;

public abstract class JmsItemReaderWriterBase
extends ItemReaderWriterBase {
    @Inject
    protected Instance<Destination> destinationInstance;
    @Inject
    protected Instance<ConnectionFactory> connectionFactoryInstance;
    @Inject
    @BatchProperty
    protected String destinationLookupName;
    @Inject
    @BatchProperty
    protected String connectionFactoryLookupName;
    @Inject
    @BatchProperty
    protected String sessionMode;
    protected Destination destination;
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Serializable checkpoint) throws Exception {
        try (InitialContext ic = null;){
            if (this.destinationLookupName != null) {
                ic = new InitialContext();
                this.destination = (Destination)ic.lookup(this.destinationLookupName);
            } else {
                this.destination = (Destination)this.destinationInstance.get();
            }
            if (this.connectionFactoryLookupName != null) {
                if (ic == null) {
                    ic = new InitialContext();
                }
                this.connectionFactory = (ConnectionFactory)ic.lookup(this.connectionFactoryLookupName);
            } else {
                this.connectionFactory = (ConnectionFactory)this.connectionFactoryInstance.get();
            }
            this.connection = this.connectionFactory.createConnection();
            int jmsMajorVersion = this.connection.getMetaData().getJMSMajorVersion();
            if (this.sessionMode != null) {
                int sessionModeInt;
                if (this.sessionMode.equals("AUTO_ACKNOWLEDGE")) {
                    sessionModeInt = 1;
                } else if (this.sessionMode.equals("DUPS_OK_ACKNOWLEDGE")) {
                    sessionModeInt = 3;
                } else if (this.sessionMode.equals("CLIENT_ACKNOWLEDGE")) {
                    sessionModeInt = 2;
                } else if (this.sessionMode.equals("SESSION_TRANSACTED")) {
                    sessionModeInt = 0;
                } else {
                    throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.sessionMode, "sessionMode");
                }
                this.session = jmsMajorVersion > 1 ? this.connection.createSession(sessionModeInt) : (sessionModeInt == 0 ? this.connection.createSession(true, 1) : this.connection.createSession(false, sessionModeInt));
            } else {
                this.session = jmsMajorVersion > 1 ? this.connection.createSession() : this.connection.createSession(false, 1);
            }
        }
    }

    protected void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close JMS session %s%n", this.session);
            }
            this.session = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close JMS connection %s%n", this.connection);
            }
            this.connection = null;
        }
    }
}

