/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.RestItemReaderWriterBase;

@Named
@Dependent
public class RestItemWriter
extends RestItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String mediaType;
    protected MediaType mediaTypeInstance;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        if (this.httpMethod == null) {
            this.httpMethod = "POST";
        } else {
            this.httpMethod = this.httpMethod.toUpperCase(Locale.ENGLISH);
            if (!"POST".equals(this.httpMethod) && !"PUT".equals(this.httpMethod)) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.httpMethod, "httpMethod");
            }
        }
        this.mediaTypeInstance = this.mediaType != null ? MediaType.valueOf((String)this.mediaType) : MediaType.APPLICATION_JSON_TYPE;
    }

    public void writeItems(List<Object> items) throws Exception {
        WebTarget target = this.client.target(this.restUrl);
        Entity entity = Entity.entity(items, (MediaType)this.mediaTypeInstance);
        Response response = "POST".equals(this.httpMethod) ? target.request().post(entity) : target.request().put(entity);
        Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
        if (statusFamily == Response.Status.Family.CLIENT_ERROR || statusFamily == Response.Status.Family.SERVER_ERROR) {
            throw SupportMessages.MESSAGES.restApiFailure(response.getStatus(), response.getStatusInfo().getReasonPhrase(), response.getEntity());
        }
    }

    public Serializable checkpointInfo() {
        return null;
    }
}

