/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.tck.impl;

import com.ibm.jbatch.tck.spi.JobExecutionTimeoutException;
import com.ibm.jbatch.tck.spi.JobExecutionWaiter;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;

public final class JobExecutionWaiterImpl
implements JobExecutionWaiter {
    private final JobExecutionImpl jobExecution;
    private final long sleepTime;

    JobExecutionWaiterImpl(long executionId, JobOperator jobOp, long sleepTime) {
        try {
            this.jobExecution = (JobExecutionImpl)jobOp.getJobExecution(executionId);
            this.sleepTime = sleepTime;
        }
        catch (JobSecurityException e) {
            throw new IllegalStateException("Failed to create JobExecutionWaiterImpl.", e);
        }
        catch (NoSuchJobExecutionException e) {
            throw new IllegalStateException("Failed to create JobExecutionWaiterImpl.", e);
        }
    }

    public JobExecution awaitTermination() throws JobExecutionTimeoutException {
        System.out.printf("Before awaitTermination for JobExecution %s, timeout %d%n", this.jobExecution, this.sleepTime);
        try {
            this.jobExecution.awaitTermination(this.sleepTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.printf("After awaitTermination for jobName %s, jobExecution %s, BatchStatus %s, StepExecutions %s%n", this.jobExecution.getJobName(), this.jobExecution.getExecutionId(), this.jobExecution.getBatchStatus(), this.jobExecution.getStepExecutions());
        for (StepExecution e : this.jobExecution.getStepExecutions()) {
            StepExecutionImpl e2 = (StepExecutionImpl)e;
            System.out.printf("StepExecution %s, batch status %s, exit status %s, exception %s%n", e2, e2.getBatchStatus(), e2.getExitStatus(), e2.getException());
        }
        return this.jobExecution;
    }
}

