/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.test.deployment;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.BatchRuntime;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Properties;

@Path(value="/simple")
public class SimpleResource {
    private static final int MAX_TRIES = 40;
    private static final int THREAD_SLEEP = 1000;

    @GET
    public String get() {
        JobOperator jobOperator = BatchRuntime.getJobOperator();
        long executionId = jobOperator.start("simple", new Properties());
        JobExecution jobExecution = jobOperator.getJobExecution(executionId);
        try {
            this.keepTestAlive(jobExecution);
            if (jobExecution.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) {
                return "OK";
            }
            return "BAD";
        }
        catch (Exception e) {
            return "ERROR";
        }
    }

    private JobExecution keepTestAlive(JobExecution jobExecution) throws InterruptedException {
        for (int maxTries = 0; !jobExecution.getBatchStatus().equals((Object)BatchStatus.COMPLETED) && maxTries < 40; ++maxTries) {
            Thread.sleep(1000L);
            jobExecution = BatchRuntime.getJobOperator().getJobExecution(jobExecution.getExecutionId());
        }
        Thread.sleep(1000L);
        return jobExecution;
    }
}

