/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.server;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.bootstrap.impl.base.server.AbstractBasicServerInitializer;
import org.jboss.bootstrap.spi.as.config.JBossASServerConfig;
import org.jboss.bootstrap.spi.as.server.JBossASServer;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.bootstrap.spi.server.Server;
import org.jboss.bootstrap.spi.server.ServerInitializer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASServerInitializer
extends AbstractBasicServerInitializer<JBossASServer, JBossASServerConfig>
implements ServerInitializer<JBossASServer, JBossASServerConfig> {
    private static final Logger log = Logger.getLogger(JBossASServerInitializer.class);

    public void initialize(JBossASServer server) throws IllegalArgumentException, IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing: " + (Object)((Object)this) + " ..."));
        }
        super.initialize((Server)server);
    }

    protected void setSystemProperties(JBossASServerConfig configuration) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting system properties for " + (Object)((Object)this) + " ..."));
        }
        super.setSystemProperties((ServerConfig)configuration);
        URL jbossHome = configuration.getJBossHome();
        String jbossHomeDir = this.getAbsoluteLocationOfUrl(jbossHome);
        URL bootLibraryUrl = configuration.getBootLibraryLocation();
        String bootLibraryString = bootLibraryUrl == null ? null : bootLibraryUrl.toExternalForm();
        URL serverBaseUrl = configuration.getServerBaseLocation();
        String serverBaseDir = this.getAbsoluteLocationOfUrl(serverBaseUrl);
        URL serverHomeUrl = configuration.getServerHomeLocation();
        String serverHomeDir = this.getAbsoluteLocationOfUrl(serverHomeUrl);
        URL commonBaseUrl = configuration.getCommonBaseLocation();
        URL commonLibUrl = configuration.getCommonLibLocation();
        String serverLogDir = this.getAbsoluteLocationOfUrl(configuration.getServerLogLocation());
        URL serverConfDir = configuration.getServerConfLocation();
        URL serverLibDir = configuration.getServerLibLocation();
        String serverDataDir = this.getAbsoluteLocationOfUrl(configuration.getServerDataLocation());
        String serverTempDir = this.getAbsoluteLocationOfUrl(configuration.getServerTempLocation());
        String partitionName = configuration.getPartitionName();
        String udpGroup = configuration.getUdpGroup();
        Integer udpPort = configuration.getUdpPort();
        Boolean loadNative = configuration.isLoadNative();
        String nativeLibLocation = this.getAbsoluteLocationOfUrl(configuration.getNativeLibraryLocation());
        Boolean usePlatformMBeanServer = configuration.isUsePlatformMBeanServer();
        this.setSystemProperty("jboss.home", jbossHomeDir);
        this.setSystemProperty("jboss.home.dir", jbossHomeDir);
        this.setSystemProperty("jboss.home.url", jbossHome);
        this.setSystemProperty("jboss.bind.address", configuration.getBindAddress());
        this.setSystemProperty("jboss.server.name", configuration.getServerName());
        this.setSystemProperty("jboss.lib.url", bootLibraryString);
        this.setSystemProperty("jboss.server.base.url", serverBaseUrl);
        this.setSystemProperty("jboss.server.base.dir", serverBaseDir);
        this.setSystemProperty("jboss.server.home.url", serverHomeUrl);
        this.setSystemProperty("jboss.server.home.dir", serverHomeDir);
        this.setSystemProperty("jboss.common.base.url", commonBaseUrl);
        this.setSystemProperty("jboss.common.lib.url", commonLibUrl);
        this.setSystemProperty("jboss.server.log.dir", serverLogDir);
        this.setSystemProperty("jboss.server.config.url", serverConfDir);
        this.setSystemProperty("jboss.server.lib.url", serverLibDir);
        this.setSystemProperty("jboss.server.data.dir", serverDataDir);
        this.setSystemProperty("jboss.server.temp.dir", serverTempDir);
        this.setSystemProperty("jboss.partition.name", partitionName);
        this.setSystemProperty("jboss.partition.udpGroup", udpGroup);
        this.setSystemProperty("jboss.jgroups.udp.mcast_port", udpPort);
        this.setSystemProperty("jboss.native.load", loadNative);
        this.setSystemProperty("jboss.native.dir", nativeLibLocation);
        this.setSystemProperty("jboss.platform.mbeanserver", usePlatformMBeanServer);
    }

    private String getAbsoluteLocationOfUrl(URL url) {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("URL be made into URI, formatting error should have been caught by config validation", urise);
        }
        File file = new File(uri);
        String location = file.getAbsolutePath();
        return location;
    }
}

