/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.config;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.jboss.bootstrap.impl.as.config.SecurityActions;
import org.jboss.bootstrap.impl.base.config.AbstractBasicConfigurationInitializer;
import org.jboss.bootstrap.spi.as.config.JBossASBasedConfigurationInitializer;
import org.jboss.bootstrap.spi.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.spi.config.InvalidConfigurationException;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASConfigurationInitializerImpl<T extends JBossASBasedServerConfig<T>>
extends AbstractBasicConfigurationInitializer<T>
implements JBossASBasedConfigurationInitializer<T> {
    private static final Logger log = Logger.getLogger(JBossASConfigurationInitializerImpl.class);
    private static final File FILE_PRESENT_WORKING_DIRECTORY = new File("");
    private static final String TRAILING_SLASH = "/";

    public void initialize(T config) throws InvalidConfigurationException, IllegalArgumentException, IllegalStateException {
        Boolean loadNative;
        String loadNativeString;
        String loadNativeResolved;
        log.debug((Object)("Initializing: " + config));
        Map configProps = config.getProperties();
        String pwd = FILE_PRESENT_WORKING_DIRECTORY.getAbsolutePath() + TRAILING_SLASH;
        String currentJBossHome = config.getJBossHome() != null ? config.getJBossHome().toExternalForm() : null;
        String jbossHome = this.resolvePropertyValue("jboss.home", "JBOSS_HOME", currentJBossHome, pwd, configProps);
        jbossHome = this.adjustToTrailingSlash(jbossHome);
        config.jbossHome(jbossHome);
        String bindAddress = this.resolvePropertyValue("jboss.bind.address", config.getBindAddress(), "127.0.0.1", configProps);
        config.bindAddress(bindAddress);
        String serverName = this.resolvePropertyValue("jboss.server.name", config.getServerName(), "default", configProps);
        config.serverName(serverName);
        URL bootLibLocation = config.getBootLibraryLocation();
        String bootLibDefault = jbossHome + "lib/";
        String currentBootLibLocation = bootLibLocation != null ? bootLibLocation.toExternalForm() : null;
        String resolvedBootLibLocation = this.resolvePropertyValue("jboss.lib.url", currentBootLibLocation, bootLibDefault, configProps);
        resolvedBootLibLocation = this.adjustToTrailingSlash(resolvedBootLibLocation);
        config.bootLibraryLocation(resolvedBootLibLocation);
        URL serverBaseLocation = config.getServerBaseLocation();
        String serverBaseDefault = jbossHome + "server/";
        String currentServerBaseLocation = serverBaseLocation != null ? serverBaseLocation.toExternalForm() : null;
        String resolvedServerBaseLocation = this.resolvePropertyValue("jboss.server.base.url", currentServerBaseLocation, serverBaseDefault, configProps);
        resolvedServerBaseLocation = this.adjustToTrailingSlash(resolvedServerBaseLocation);
        config.serverBaseLocation(resolvedServerBaseLocation);
        URL serverHomeLocation = config.getServerHomeLocation();
        String serverHomeDefault = resolvedServerBaseLocation + serverName;
        String currentServerHomeLocation = serverHomeLocation != null ? serverHomeLocation.toExternalForm() : null;
        String resolvedServerHomeLocation = this.resolvePropertyValue("jboss.server.home.url", currentServerHomeLocation, serverHomeDefault, configProps);
        resolvedServerHomeLocation = this.adjustToTrailingSlash(resolvedServerHomeLocation);
        config.serverHomeLocation(resolvedServerHomeLocation);
        URL commonBaseLocation = config.getCommonBaseLocation();
        String commonBaseDefault = jbossHome + "common/";
        String currentCommonBaseLocation = commonBaseLocation != null ? commonBaseLocation.toExternalForm() : null;
        String resolvedCommonBaseLocation = this.resolvePropertyValue("jboss.common.base.url", currentCommonBaseLocation, commonBaseDefault, configProps);
        resolvedCommonBaseLocation = this.adjustToTrailingSlash(resolvedCommonBaseLocation);
        config.commonBaseLocation(resolvedCommonBaseLocation);
        URL commonLibLocation = config.getCommonLibLocation();
        String commonLibDefault = resolvedCommonBaseLocation + "lib/";
        String currentCommonLibLocation = commonLibLocation != null ? commonLibLocation.toExternalForm() : null;
        String resolvedCommonLibLocation = this.resolvePropertyValue("jboss.common.lib.url", currentCommonLibLocation, commonLibDefault, configProps);
        resolvedCommonLibLocation = this.adjustToTrailingSlash(resolvedCommonLibLocation);
        config.commonLibLocation(resolvedCommonLibLocation);
        URL serverLogLocation = config.getServerLogLocation();
        String serverLogDefault = resolvedServerHomeLocation + "log/";
        String currentServerLogLocation = serverLogLocation != null ? serverLogLocation.toExternalForm() : null;
        String resolvedServerLogLocation = this.resolvePropertyValue("jboss.server.log.dir", currentServerLogLocation, serverLogDefault, configProps);
        resolvedServerLogLocation = this.adjustToTrailingSlash(resolvedServerLogLocation);
        config.serverLogLocation(resolvedServerLogLocation);
        URL serverConfLocation = config.getServerConfLocation();
        String serverConfDefault = resolvedServerHomeLocation + "conf/";
        String currentServerConfLocation = serverConfLocation != null ? serverConfLocation.toExternalForm() : null;
        String resolvedServerConfLocation = this.resolvePropertyValue("jboss.server.config.url", currentServerConfLocation, serverConfDefault, configProps);
        resolvedServerConfLocation = this.adjustToTrailingSlash(resolvedServerConfLocation);
        config.serverConfLocation(resolvedServerConfLocation);
        super.initialize(config);
        URL serverLibLocation = config.getServerLibLocation();
        String serverLibDefault = resolvedServerHomeLocation + "lib/";
        String currentServerLibLocation = serverLibLocation != null ? serverLibLocation.toExternalForm() : null;
        String resolvedServerLibLocation = this.resolvePropertyValue("jboss.server.lib.url", currentServerLibLocation, serverLibDefault, configProps);
        resolvedServerLibLocation = this.adjustToTrailingSlash(resolvedServerLibLocation);
        config.serverLibLocation(resolvedServerLibLocation);
        URL serverDataLocation = config.getServerDataLocation();
        String serverDataDefault = resolvedServerHomeLocation + "data/";
        String currentServerDataLocation = serverDataLocation != null ? serverDataLocation.toExternalForm() : null;
        String resolvedServerDataLocation = this.resolvePropertyValue("jboss.server.data.dir", currentServerDataLocation, serverDataDefault, configProps);
        resolvedServerDataLocation = this.adjustToTrailingSlash(resolvedServerDataLocation);
        config.serverDataLocation(resolvedServerDataLocation);
        URL serverTempLocation = config.getServerTempLocation();
        String serverTempDefault = resolvedServerHomeLocation + "tmp/";
        String currentServerTempLocation = serverTempLocation != null ? serverTempLocation.toExternalForm() : null;
        String resolvedServerTempLocation = this.resolvePropertyValue("jboss.server.temp.dir", currentServerTempLocation, serverTempDefault, configProps);
        resolvedServerTempLocation = this.adjustToTrailingSlash(resolvedServerTempLocation);
        config.serverTempLocation(resolvedServerTempLocation);
        String bootstrapName = config.getBootstrapName();
        assert (bootstrapName != null && bootstrapName.length() > 0) : "Bootstrap name is not supplied, perhaps the super impl was not yet initialized?";
        String bootstrapHomeDefault = resolvedServerConfLocation + bootstrapName;
        String resolvedBootstrapHome = this.resolvePropertyValue("jboss.bootstrap.home.url", null, bootstrapHomeDefault, configProps);
        resolvedBootstrapHome = this.adjustToTrailingSlash(resolvedBootstrapHome);
        config.bootstrapHome(resolvedBootstrapHome);
        String partitionName = this.resolvePropertyValue("jboss.partition.name", config.getPartitionName(), "DefaultPartition", configProps);
        config.partitionName(partitionName);
        String udpGroup = this.resolvePropertyValue("jboss.partition.udpGroup", config.getUdpGroup(), null, configProps);
        config.udpGroup(udpGroup);
        Integer udpPort = config.getUdpPort();
        String udpPortString = udpPort != null ? udpPort.toString() : null;
        String udpPortResolved = this.resolvePropertyValue("jboss.jgroups.udp.mcast_port", udpPortString, null, configProps);
        if (udpPortResolved != null) {
            try {
                int udpPortOverride = Integer.parseInt(udpPortResolved);
                config.udpPort(Integer.valueOf(udpPortOverride));
            }
            catch (NumberFormatException nfe) {
                throw new InvalidConfigurationException("UDP Port overridden to non-integer value", (Throwable)nfe);
            }
        }
        if ((loadNativeResolved = this.resolvePropertyValue("jboss.native.load", loadNativeString = (loadNative = config.isLoadNative()) != null ? loadNative.toString() : null, JBossASBasedConfigurationInitializer.VALUE_NATIVE_LOAD_DEFAULT.toString(), configProps)) != null) {
            boolean loadNativeOverride = Boolean.parseBoolean(loadNativeResolved);
            config.loadNative(Boolean.valueOf(loadNativeOverride));
        }
        URL nativeLibLocation = config.getNativeLibraryLocation();
        String nativeLibDefault = resolvedServerTempLocation + "native/";
        String currentNativeLibLocation = nativeLibLocation != null ? nativeLibLocation.toExternalForm() : null;
        String resolvedNativeLibLocation = this.resolvePropertyValue("jboss.native.dir", currentNativeLibLocation, nativeLibDefault, configProps);
        resolvedNativeLibLocation = this.adjustToTrailingSlash(resolvedNativeLibLocation);
        config.nativeLibraryLocation(resolvedNativeLibLocation);
        Boolean platformMBeanServer = config.isUsePlatformMBeanServer();
        String platformMBeanServerString = platformMBeanServer != null ? platformMBeanServer.toString() : null;
        String platformMBeanServerResolved = this.resolvePropertyValue("jboss.platform.mbeanserver", platformMBeanServerString, JBossASBasedConfigurationInitializer.VALUE_PLATFORM_MBEAN_SERVER_DEFAULT.toString(), configProps);
        if (platformMBeanServerResolved != null) {
            boolean platformMbeanServerOverride = Boolean.parseBoolean(platformMBeanServerResolved);
            config.usePlatformMBeanServer(Boolean.valueOf(platformMbeanServerOverride));
        }
    }

    protected URL getDefaultBootstrapHome(T config) {
        return config.getServerConfLocation();
    }

    private String adjustToTrailingSlash(String string) {
        String newString = string;
        if (!newString.endsWith(TRAILING_SLASH)) {
            newString = newString + TRAILING_SLASH;
        }
        return newString;
    }

    private String resolvePropertyValue(String propertyName, String currentValue, String defaultValue, Map<String, String> properties) throws IllegalArgumentException {
        return this.resolvePropertyValue(propertyName, null, currentValue, defaultValue, properties);
    }

    String resolvePropertyValue(String propertyName, String envVarName, String currentValue, String defaultValue, Map<String, String> properties) throws IllegalArgumentException {
        String override;
        String envVarValue;
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name is a required argument");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Properties is a required argument");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Determining true value for property: " + propertyName));
        }
        String returnValue = defaultValue;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Default value of \"" + propertyName + "\" is: " + defaultValue));
        }
        if (envVarName != null && (envVarValue = SecurityActions.getEnvironmentVariable(envVarName)) != null) {
            returnValue = envVarValue;
            log.debug((Object)("Found environment variable \"" + envVarName + "\", so using value as override: " + envVarValue));
        }
        if (currentValue != null && currentValue.length() > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Object model has specified value for \"" + propertyName + "\": " + currentValue));
            }
            returnValue = currentValue;
        }
        if ((override = properties.get(propertyName)) != null && override.length() > 0) {
            log.debug((Object)("Got configuration property " + propertyName + ", so using as override: " + override));
            returnValue = override;
        }
        log.debug((Object)("Resolved property: " + propertyName + " with currentValue = " + currentValue + ", environment variable name = " + envVarName + ", and defaultValue = " + defaultValue + " to: " + returnValue));
        return returnValue;
    }
}

