/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bootstrap.impl.base.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.namespace.QName;

import org.jboss.bootstrap.spi.metadata.BootstrapMetaData;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;

/**
 * SchemaBinding for the bootstrap
 *
 * @author <a href="mailto:adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 71554 $
 */
class BootstrapSchemaBinding extends SchemaBinding
{
   /** The bootstrap namespace */
   public static final String NAMESPACE = "urn:jboss:bootstrap:1.0";

   /**
    * Create a new BootstrapSchemaBinding.
    */
   public BootstrapSchemaBinding()
   {
      TypeBinding stringType = getType(SimpleTypeBindings.typeQName(String.class));

      setNamespaces(Collections.singleton(NAMESPACE));
      setIgnoreLowLine(true);
      setIgnoreUnresolvedFieldOrClass(false);
      setReplacePropertyRefs(true);
      setStrictSchema(true);

      // The bootstrap type
      TypeBinding bootstrapType = new TypeBinding(new QName(NAMESPACE, "bootstrapType"));
      bootstrapType.setSimple(false);
      AllBinding bootstrapModel = new AllBinding(this);
      ParticleBinding bootstrapParticle = new ParticleBinding(bootstrapModel, 1, 1, false);
      bootstrapType.setParticle(bootstrapParticle);
      ClassMetaData bootstrapClassMetaData = new ClassMetaData();
      bootstrapClassMetaData.setImpl(BootstrapMetaData.class.getName());
      bootstrapType.setClassMetaData(bootstrapClassMetaData);

      // Bootstrap can take some urls
      ElementBinding urlElement = new ElementBinding(this, new QName(NAMESPACE, "url"), stringType);
      ParticleBinding urlParticle = new ParticleBinding(urlElement, 0, 1, true);
      bootstrapModel.addParticle(urlParticle);
      bootstrapType.pushInterceptor(urlElement.getQName(), new DefaultElementInterceptor()
      {
         public void add(Object parent, Object child, QName name)
         {
            BootstrapMetaData bootstrap = (BootstrapMetaData) parent;
            String url = (String) child;
            List<String> bootstrapURLs = bootstrap.getBootstrapURLs();
            if (bootstrapURLs == null)
            {
               bootstrapURLs = new ArrayList<String>();
               bootstrap.setBootstrapURLs(bootstrapURLs);
            }
            bootstrapURLs.add(url);
         }
      });

      // The bootstrap root element
      addElement(new ElementBinding(this, new QName(NAMESPACE, "bootstrap"), bootstrapType));
   }
}
