/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jboss.bootstrap.impl.base.config.SecurityActions;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.InvalidConfigurationException;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicConfigurationInitializer<T extends ServerConfig<T>>
implements ConfigurationInitializer<T> {
    private static final Logger log = Logger.getLogger(AbstractBasicConfigurationInitializer.class);

    public void initialize(T config) throws InvalidConfigurationException, IllegalArgumentException, IllegalStateException {
        this._initialize(config);
    }

    private void _initialize(T config) throws InvalidConfigurationException, IllegalArgumentException, IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing: " + config));
        }
        this.applyPropertyOverrides(config);
        URL bootstrapUrl = config.getBootstrapUrl();
        URL home = config.getBootstrapHome();
        String name = config.getBootstrapName();
        if (bootstrapUrl == null && home != null && name != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No bootstrap URL defined, constructing it from home and name...");
            }
            URL newBootstrapUrl = null;
            try {
                newBootstrapUrl = new URL(home, name);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException((Throwable)new InvalidConfigurationException("Cannot construct bootstrapURL from home and name", (Throwable)e));
            }
            log.debug((Object)("New bootstrap URL: " + newBootstrapUrl.toExternalForm()));
            config.bootstrapUrl(newBootstrapUrl);
        }
        if (name == null || name.length() == 0) {
            config.bootstrapName(this.getDefaultBootstrapName(config));
            this._initialize(config);
        }
        if (home == null) {
            URL newHome = this.getDefaultBootstrapHome(config);
            config.bootstrapHome(newHome);
            this._initialize(config);
        }
    }

    protected String getDefaultBootstrapName(T config) {
        return "bootstrap.xml";
    }

    protected URL getDefaultBootstrapHome(T config) {
        return SecurityActions.getCodeSourceLocation(this.getClass());
    }

    protected void applyPropertyOverrides(T config) throws IllegalArgumentException {
        String overrideName;
        String overrideUrl;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Applying system property overrides...");
        }
        if (config == null) {
            throw new IllegalArgumentException("Supplied configuration is null");
        }
        Map properties = config.getProperties();
        String overrideHome = this.getOverrideValue("jboss.bootstrap.home.url", properties);
        if (overrideHome != null) {
            config.bootstrapHome(overrideHome);
        }
        if ((overrideUrl = this.getOverrideValue("jboss.bootstrap.url", properties)) != null) {
            config.bootstrapUrl(overrideUrl);
        }
        if ((overrideName = this.getOverrideValue("jboss.bootstrap.name", properties)) != null) {
            config.bootstrapName(overrideName);
        }
    }

    private String getOverrideValue(String propertyName, Map<String, String> properties) throws IllegalArgumentException {
        String override = properties.get(propertyName);
        if (override != null && override.length() == 0) {
            override = null;
        }
        if (override != null && override.length() > 0) {
            log.debug((Object)("Got system property " + propertyName + ", so using as override: " + override));
        }
        return override;
    }
}

