/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.config;

import java.net.URL;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.api.config.ServerConfig;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicConfigurationValidator<T extends ServerConfig<T>>
implements ConfigurationValidator<T> {
    private static final Logger log = Logger.getLogger(AbstractBasicConfigurationValidator.class);

    public void validate(T config) throws InvalidConfigurationException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Validating configuration: " + config));
        }
        if (config == null) {
            throw new IllegalArgumentException("Configuration is required, but was not supplied");
        }
        String name = config.getBootstrapName();
        URL home = config.getBootstrapHome();
        URL direct = config.getBootstrapUrl();
        if (direct == null && (home == null || name == null || name.length() == 0)) {
            throw new InvalidConfigurationException("If the bootstrap URL is not specified, both the bootstrap home and name must be.");
        }
        log.debug((Object)("Configuration passed on: " + config));
    }
}

