/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.logging.Logger;

class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class);

    private SecurityActions() {
    }

    static void setSystemProperty(final String key, final String value) throws IllegalArgumentException {
        SecurityActions.ensureSysPropKeySpecified(key);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(key, value);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Set system property \"" + key + "\" > " + value));
                }
                return null;
            }
        });
    }

    static void clearSystemProperty(final String key) throws IllegalArgumentException {
        SecurityActions.ensureSysPropKeySpecified(key);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String previousValue = System.clearProperty(key);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removed system property \"" + key + "\" which had previous value: " + previousValue));
                }
                return null;
            }
        });
    }

    static <T> T newInstance(final Class<T> clazz) throws IllegalArgumentException, Throwable {
        if (clazz == null) {
            throw new IllegalArgumentException("Class is a required argument");
        }
        Object newInstance = null;
        try {
            newInstance = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Attempting to create new instance of " + clazz));
                    }
                    Object obj = clazz.newInstance();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Created " + obj));
                    }
                    return obj;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getCause();
        }
        T returnValue = clazz.cast(newInstance);
        return returnValue;
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setThreadContextClassLoader(final ClassLoader cl) throws IllegalArgumentException {
        if (cl == null) {
            throw new IllegalArgumentException("ClassLoader was null");
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    private static void ensureSysPropKeySpecified(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Key for System Property was not specified");
        }
    }
}

