/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.embedded.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.bootstrap.api.embedded.server.JBossASEmbeddedServer;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.bootstrap.impl.as.config.BasicJBossASServerConfig;
import org.jboss.bootstrap.impl.as.server.AbstractJBossASServerBase;
import org.jboss.bootstrap.impl.embedded.lifecycle.IgnoreXbUnorderedSequenceLifecycleEventHandler;
import org.jboss.bootstrap.impl.embedded.lifecycle.InitLoggingManagerLifecycleEventHandler;
import org.jboss.bootstrap.impl.embedded.lifecycle.SetRmiHostnameLifecycleEventHandler;
import org.jboss.bootstrap.impl.embedded.server.SecurityActions;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.tmpdpl.api.deployable.Deployable;
import org.jboss.tmpdpl.impl.vdf.VfsVdfDeployableImpl;
import org.jboss.tmpdpl.spi.vdf.VdfDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASEmbeddedServerImpl
extends AbstractJBossASServerBase<JBossASEmbeddedServer, JBossASServerConfig>
implements JBossASEmbeddedServer {
    private static final Logger log = Logger.getLogger(JBossASEmbeddedServerImpl.class);
    public static final String ENV_VAR_JBOSS_HOME = "JBOSS_HOME";
    public static final String SYS_PROP_JBOSS_HOME = "jboss.home";
    private static final String MC_NAME_MAIN_DEPLOYER = "MainDeployer";
    private final Map<Deployable, Deployment> deployableToDeploymentMap = new ConcurrentHashMap<Deployable, Deployment>();

    public JBossASEmbeddedServerImpl() throws IllegalStateException {
        super(JBossASEmbeddedServer.class);
        String jbossHome = SecurityActions.getSystemProperty(SYS_PROP_JBOSS_HOME);
        if (jbossHome == null) {
            jbossHome = SecurityActions.getEnvironmentVariable(ENV_VAR_JBOSS_HOME);
            log.info((Object)("Using JBOSS_HOME Environment Variable: " + jbossHome));
        } else {
            log.info((Object)("Using jboss.home System Property: " + jbossHome));
        }
        if (jbossHome == null) {
            throw new IllegalStateException("JBOSS_HOME must be specified, either via environment variable \"JBOSS_HOME\" or system property \"jboss.home\".");
        }
        this.initialize(jbossHome);
    }

    public JBossASEmbeddedServerImpl(String jbossHome) throws IllegalArgumentException {
        super(JBossASEmbeddedServer.class);
        this.initialize(jbossHome);
    }

    public void deploy(Deployable ... deployables) throws org.jboss.tmpdpl.api.container.DeploymentException, IllegalArgumentException {
        Collection<VdfDeployable> vdfDeployables = this.asVdfDeployables(deployables);
        MainDeployer mainDeployer = this.getMainDeployer();
        for (VdfDeployable vdfDeployable : vdfDeployables) {
            Deployment deployment = vdfDeployable.getDeployment();
            log.debug((Object)("Adding to " + mainDeployer + ": " + deployment));
            try {
                mainDeployer.addDeployment(deployment);
            }
            catch (DeploymentException de) {
                throw new org.jboss.tmpdpl.api.container.DeploymentException((Throwable)de);
            }
            this.deployableToDeploymentMap.put((Deployable)vdfDeployable, deployment);
        }
        this.processAndCheckMainDeployer(mainDeployer);
    }

    public void undeploy(Deployable ... deployables) throws org.jboss.tmpdpl.api.container.DeploymentException, IllegalArgumentException {
        if (deployables == null || deployables.length == 0) {
            throw new IllegalArgumentException("At least one deployable must be specified");
        }
        MainDeployer mainDeployer = this.getMainDeployer();
        for (Deployable deployable : deployables) {
            Deployment deployment = this.getDeployablesToDeploymentsMap().get(deployable);
            if (deployment == null) {
                log.warn((Object)("Specified deployable " + deployable + " cannot be undeployed because it is not deployed."));
                continue;
            }
            try {
                mainDeployer.removeDeployment(deployment);
            }
            catch (DeploymentException de) {
                throw new org.jboss.tmpdpl.api.container.DeploymentException((Throwable)de);
            }
            this.deployableToDeploymentMap.remove(deployable);
        }
        this.processAndCheckMainDeployer(mainDeployer);
    }

    protected Class<? extends JBossASServerConfig> getDefaultServerConfigClass() {
        return BasicJBossASServerConfig.class;
    }

    public void deploy(Archive<?> ... archives) throws org.jboss.tmpdpl.api.container.DeploymentException, IllegalArgumentException {
        Deployable[] deployables = this.asDeployableArray(archives);
        this.deploy(deployables);
    }

    public void undeploy(Archive<?> ... archives) throws org.jboss.tmpdpl.api.container.DeploymentException, IllegalArgumentException {
        Deployable[] deployables = this.asDeployableArray(archives);
        this.undeploy(deployables);
    }

    private void initialize(String jbossHome) throws IllegalArgumentException {
        if (jbossHome == null || jbossHome.length() == 0) {
            throw new IllegalArgumentException("JBOSS_HOME is required but was not specified");
        }
        ((JBossASServerConfig)this.getConfiguration()).jbossHome(jbossHome);
        IgnoreXbUnorderedSequenceLifecycleEventHandler ignoreXbOrder = new IgnoreXbUnorderedSequenceLifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, ignoreXbOrder);
        SetRmiHostnameLifecycleEventHandler setRmiHostname = new SetRmiHostnameLifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, setRmiHostname);
        InitLoggingManagerLifecycleEventHandler initLoggingManager = new InitLoggingManagerLifecycleEventHandler();
        this.registerEventHandler(LifecycleState.INITIALIZED, initLoggingManager);
        log.warn((Object)((Object)((Object)this) + " has not installed any handler for a boot.log in $JBOSS_HOME/server/[name]/log"));
    }

    private Deployable[] asDeployableArray(Archive<?> ... archives) throws IllegalArgumentException {
        if (archives == null || archives.length == 0) {
            throw new IllegalArgumentException("At least one archive must be specified");
        }
        ArrayList<VdfDeployable> deployables = new ArrayList<VdfDeployable>();
        for (Archive<?> archive : archives) {
            VdfDeployable deployable = VfsVdfDeployableImpl.create(archive);
            deployables.add(deployable);
        }
        return deployables.toArray(new Deployable[0]);
    }

    @Deprecated
    protected final MainDeployer getMainDeployer() {
        Kernel kernel = this.getKernel();
        KernelController controller = kernel.getController();
        ControllerContext context = controller.getContext((Object)MC_NAME_MAIN_DEPLOYER, ControllerState.INSTALLED);
        if (context == null) {
            throw new IllegalStateException("Main deployer could not be found");
        }
        Object target = context.getTarget();
        MainDeployer mainDeployer = (MainDeployer)MainDeployer.class.cast(target);
        return mainDeployer;
    }

    private Collection<VdfDeployable> asVdfDeployables(Deployable ... deployables) throws IllegalArgumentException {
        return this.asExpectedTypeCollection(VdfDeployable.class, deployables);
    }

    private <T> Collection<T> asExpectedTypeCollection(Class<T> expectedType, Object[] objects) throws IllegalArgumentException {
        assert (objects != null && objects.length > 0) : "At least one object must be specified";
        ArrayList<T> typedCollection = new ArrayList<T>();
        for (Object object : objects) {
            if (!expectedType.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Unsupported; must be of type \"" + expectedType.getName() + "\" but was " + object.getClass().getName());
            }
            T typedObject = expectedType.cast(object);
            typedCollection.add(typedObject);
        }
        return typedCollection;
    }

    @Deprecated
    private void processAndCheckMainDeployer(MainDeployer mainDeployer) throws org.jboss.tmpdpl.api.container.DeploymentException, IllegalArgumentException {
        if (mainDeployer == null) {
            throw new IllegalArgumentException("mainDeployer must be specified");
        }
        log.debug((Object)("Processing: " + mainDeployer));
        mainDeployer.process();
        try {
            log.debug((Object)("Checking: " + mainDeployer));
            mainDeployer.checkComplete();
        }
        catch (DeploymentException de) {
            throw new org.jboss.tmpdpl.api.container.DeploymentException((Throwable)de);
        }
    }

    protected final Map<Deployable, Deployment> getDeployablesToDeploymentsMap() {
        return Collections.unmodifiableMap(this.deployableToDeploymentMap);
    }
}

