/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.mc.server;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.bootstrap.impl.base.server.AbstractServer;
import org.jboss.bootstrap.impl.base.xml.BootstrapParser;
import org.jboss.bootstrap.impl.mc.deployer.TempBasicXMLDeployer;
import org.jboss.bootstrap.spi.mc.config.MCBasedServerConfig;
import org.jboss.bootstrap.spi.mc.server.MCBasedServer;
import org.jboss.bootstrap.spi.metadata.BootstrapMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMCServerBase<K extends MCBasedServer<K, T>, T extends MCBasedServerConfig<T>>
extends AbstractServer<K, T>
implements MCBasedServer<K, T> {
    private static final Logger log = Logger.getLogger(AbstractMCServerBase.class);
    private BasicBootstrap bootstrap;
    private Kernel kernel;
    private TempBasicXMLDeployer kernelDeployer;

    protected AbstractMCServerBase() {
        this(null);
    }

    protected AbstractMCServerBase(T config) {
        super(config);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    protected void doShutdown() throws Exception {
        try {
            if (this.kernelDeployer != null) {
                this.kernelDeployer.shutdown();
                this.kernelDeployer = null;
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error stopping xml deployer", t);
        }
        try {
            Kernel currentKernel = null;
            if (this.kernel != null) {
                currentKernel = this.kernel;
                this.kernel = null;
            } else if (this.bootstrap != null) {
                currentKernel = this.bootstrap.getKernel();
            }
            this.bootstrap = null;
            if (currentKernel != null) {
                KernelController controller = currentKernel.getController();
                controller.shutdown();
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error stopping xml deployer", t);
        }
    }

    protected void doStart() throws Exception {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.kernel = bootstrap.getKernel();
        this.bootstrap = bootstrap;
        String mcServerBindName = "JBossServer";
        KernelController controller = this.kernel.getController();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"JBossServer", (String)((Object)((Object)this)).getClass().getName());
        builder.addMethodInstallCallback("addBootstrap");
        builder.addMethodUninstallCallback("removeBootstrap");
        builder.ignoreStart();
        try {
            log.debug((Object)("Installing " + (Object)((Object)this) + " into MC under key: " + "JBossServer"));
            controller.install(builder.getBeanMetaData(), (Object)this);
        }
        catch (Throwable t) {
            throw new Exception("Error in installing JBossServer during startup", t);
        }
        MCBasedServerConfig config = (MCBasedServerConfig)this.getConfiguration();
        URL configURL = config.getBootstrapConfLocation();
        URL bootstrapUrl = config.getBootstrapUrl();
        log.info((Object)("Starting Microcontainer, Main bootstrapURL=" + bootstrapUrl));
        BootstrapMetaData bootstrapMetaData = BootstrapParser.parse((URL)bootstrapUrl);
        List<String> bootstrapURLs = bootstrapMetaData.getBootstrapURLs();
        if (bootstrapURLs == null) {
            bootstrapURLs = Collections.emptyList();
        }
        if (bootstrapURLs.isEmpty()) {
            log.warn((Object)("No bootstrap urls in " + bootstrapUrl));
        }
        log.debug((Object)("BootstrapURLs=" + bootstrapURLs));
        log.debug((Object)("Bootstrap URLs are relative to: " + configURL));
        this.kernelDeployer = new TempBasicXMLDeployer(this.kernel);
        try {
            for (String bootstrapURL : bootstrapURLs) {
                log.debug((Object)("BEFORE: " + bootstrapURL));
                URL suburl = new URL(configURL, bootstrapURL);
                log.debug((Object)("Deploying bootstrap xml: " + suburl));
                this.kernelDeployer.deploy(suburl);
            }
            this.kernelDeployer.validate();
        }
        catch (Throwable t) {
            try {
                this.kernelDeployer.shutdown();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new Exception("Encountered exception in server startup", t);
        }
    }
}

