/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.mc.server;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.bootstrap.impl.base.server.AbstractServer;
import org.jboss.bootstrap.impl.base.xml.BootstrapParser;
import org.jboss.bootstrap.impl.mc.deployer.TempBasicXMLDeployer;
import org.jboss.bootstrap.spi.config.InvalidConfigurationException;
import org.jboss.bootstrap.spi.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.spi.mc.config.MCBasedServerConfig;
import org.jboss.bootstrap.spi.mc.server.MCBasedServer;
import org.jboss.bootstrap.spi.metadata.BootstrapMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMCServerBase<K extends MCBasedServer<K, T>, T extends MCBasedServerConfig<T>>
extends AbstractServer<K, T>
implements MCBasedServer<K, T> {
    private static final Logger log = Logger.getLogger(AbstractMCServerBase.class);
    private BasicBootstrap bootstrap;
    private TempBasicXMLDeployer kernelDeployer;

    protected AbstractMCServerBase(Class<K> actualClass) {
        this(actualClass, null);
    }

    protected AbstractMCServerBase(Class<K> actualClass, T config) {
        super(actualClass, config);
    }

    @ManagementProperty(name="config")
    public final T getConfiguration() {
        return (T)((MCBasedServerConfig)super.getConfiguration());
    }

    @ManagementProperty(ignored=true)
    public Kernel getKernel() {
        return this.getBootstrap().getKernel();
    }

    @ManagementProperty(ignored=true)
    public Map<String, KernelDeployment> getDeployments() {
        Map<String, KernelDeployment> deployments = null;
        if (this.kernelDeployer != null) {
            deployments = this.kernelDeployer.getDeployments();
        }
        return deployments;
    }

    protected void doShutdown() throws Exception {
        try {
            if (this.kernelDeployer != null) {
                this.kernelDeployer.shutdown();
                this.kernelDeployer = null;
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error stopping xml deployer", t);
        }
        try {
            Kernel tempKernelReference = null;
            if (this.bootstrap != null) {
                tempKernelReference = this.bootstrap.getKernel();
            }
            this.bootstrap = null;
            if (tempKernelReference != null) {
                KernelController controller = tempKernelReference.getController();
                controller.shutdown();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error stopping " + KernelController.class.getName()), (Throwable)e);
        }
    }

    public synchronized void initialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        this.initializeBootstrap();
        super.initialize();
    }

    public synchronized void start() throws IllegalStateException, Exception {
        BasicBootstrap bootstrap = this.getBootstrap();
        if (bootstrap == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Re-initializing the underlying bootstrap...");
            }
            this.initializeBootstrap();
            log.debug((Object)"Underlying MC Bootstrap re-initialized.");
        }
        super.start();
    }

    protected void doStart() throws Exception {
        String mcServerBindName = "JBossServer";
        Kernel kernel = this.getKernel();
        if (kernel == null) {
            throw new IllegalStateException("Server cannot be started without the presence of an underlying " + Kernel.class.getName());
        }
        KernelController controller = kernel.getController();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"JBossServer", (String)((Object)((Object)this)).getClass().getName());
        builder.addMethodInstallCallback("addBootstrap");
        builder.addMethodUninstallCallback("removeBootstrap");
        builder.ignoreStart();
        try {
            log.debug((Object)("Installing " + (Object)((Object)this) + " into MC under key: " + "JBossServer"));
            controller.install(builder.getBeanMetaData(), (Object)this);
        }
        catch (Throwable t) {
            throw new Exception("Error in installing JBossServer during startup", t);
        }
        T config = this.getConfiguration();
        URL homeUrl = config.getBootstrapHome();
        URL bootstrapUrl = config.getBootstrapUrl();
        log.info((Object)("Starting Microcontainer, Main bootstrapURL=" + bootstrapUrl));
        BootstrapMetaData bootstrapMetaData = BootstrapParser.parse((URL)bootstrapUrl);
        List<String> bootstrapURLs = bootstrapMetaData.getBootstrapURLs();
        if (bootstrapURLs == null) {
            bootstrapURLs = Collections.emptyList();
        }
        if (bootstrapURLs.isEmpty()) {
            log.warn((Object)("No bootstrap urls in " + bootstrapUrl));
        }
        log.debug((Object)("BootstrapURLs=" + bootstrapURLs));
        log.debug((Object)("Bootstrap URLs are relative to: " + homeUrl));
        this.kernelDeployer = new TempBasicXMLDeployer(kernel);
        try {
            for (String bootstrapURL : bootstrapURLs) {
                URL suburl = new URL(homeUrl, bootstrapURL);
                log.debug((Object)("Deploying bootstrap xml: " + suburl));
                this.kernelDeployer.deploy(suburl);
            }
            this.kernelDeployer.validate();
        }
        catch (Throwable t) {
            try {
                this.kernelDeployer.shutdown();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new Exception("Encountered exception in server startup", t);
        }
    }

    protected final BasicBootstrap getBootstrap() {
        return this.bootstrap;
    }

    private void initializeBootstrap() {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.bootstrap = bootstrap;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created and run: " + bootstrap));
        }
    }
}

