/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bootstrap.spi.as.server;

import java.util.Date;
import java.util.Map;

import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.api.as.server.JBossASBasedServer;
import org.jboss.bootstrap.api.server.Server;
import org.jboss.bootstrap.spi.mc.server.MCBasedServerProvider;

/**
 * JBossASBasedServerProvider
 * 
 * Contract for implementations of JBoss Application Servers 
 * and extensions thereof
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public interface JBossASBasedServerProvider<K extends JBossASBasedServer<K, T>, T extends JBossASBasedServerConfig<T>>
      extends
         MCBasedServerProvider<K, T>,
         JBossASBasedServer<K, T>
{
   //-------------------------------------------------------------------------------------||
   // Contracts --------------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /** @return The server start date */
   Date getStartDate();

   /** @return The server version, the underlying version expressed as a String */
   String getVersion();

   /** @return The server version code name */
   String getVersionName();

   /** @return The full server version number */
   String getVersionNumber();

   /** @return The date the server was build (compiled) */
   String getBuildNumber();

   /** @return The JVM used to build the server */
   String getBuildJVM();

   /** @return The Operating System used to build the server */
   String getBuildOS();

   /** @return The build id */
   String getBuildID();

   /** @return The date the server was build */
   String getBuildDate();

   /**
    * Get the optional server configuration metadata
    * 
    * @return A possibly empty map of configuration metadata
    */
   Map<String, Object> getMetaData();

   /**
    * Returns whether or not the server is started.
    * 
    * JBBOOT-80
    * @return
    * @deprecated Should be removed when we won't be targeting
    * jboss-bootstrap for AS 5.x anymore.  AS6 will not support 
    * this invocation, instead we should use {@link Server#getState()} 
    */
   @Deprecated
   boolean isStarted();
}
