/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.classpool.plugins.jbosscl;

import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;

/**
 * Entry point to determining the parent classloader.
 * 
 * AbstractDeploymentClassLoaderPolicyModule is only available after deploying deployers.xml in AS
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class ParentUnitLoaderFinders
{
   private static final ParentUnitLoaderFinders INSTANCE = new ParentUnitLoaderFinders();
   
   private final ParentUnitLoaderFinder defaultUnitLoaderFinder = new BootstrapParentUnitFinder();
   
   private volatile ParentUnitLoaderFinder abstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder;
   
   /**
    * Get the singleton instance
    * 
    * @return the singleton
    */
   static ParentUnitLoaderFinders getInstance()
   {
      return INSTANCE;
   }
   
   /**
    * Calls the registered parent unit loader finders.
    * {@link BootstrapParentUnitFinder} is always available. Once AbstractDeploymentClassLoaderPolicyModule
    * has been deployed its ParentUnitLoaderFinder (AbstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder) is checked 
    * if the module is of the correct type.
    */
   ClassLoader findParentUnitLoader(Module module)
   {
      if (module == null)
         throw new IllegalArgumentException("Null module");
      
      if (abstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder == null)
         initAbstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder(module);
      
      if (abstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder != null &&
            abstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder.handle(module))
         return abstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder.findParentUnitLoader(module);
      else
         return defaultUnitLoaderFinder.findParentUnitLoader(module);
   }
   
   private synchronized void initAbstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder(Module module)
   {
      if (abstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder == null)
      {
         ClassLoader loader = ClassLoading.getClassLoaderForModule(module);
         Class<?> finder;
         try
         {
            finder = SecurityActions.loadClass(loader, "org.jboss.classpool.plugins.jbosscl.as.AbstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder");
         }
         catch (ClassNotFoundException e)
         {
            //The loader for this class has not been loaded yet
            return;
         }
         try
         {
            abstractDeploymentClassLoaderPolicyModuleParentUnitLoaderFinder = (ParentUnitLoaderFinder)finder.newInstance();
         }
         catch (InstantiationException e)
         {
            throw new RuntimeException(e);
         }
         catch (IllegalAccessException e)
         {
            throw new RuntimeException(e);
         }
      }
   }
}
