/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.support;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.classpool.jbosscl.support.DomainRegistry;
import org.jboss.test.classpool.jbosscl.support.TestVFSClassLoaderFactory;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLDeploymentBuilder
implements ClassLoaderInfo {
    private static ClassLoadingMetaDataFactory clmdf = ClassLoadingMetaDataFactory.getInstance();
    List<Capability> capabilities = new ArrayList<Capability>();
    List<Requirement> requirements = new ArrayList<Requirement>();
    private String name;
    private URL[] urls;
    private URL[] excludes;
    private boolean importAll;
    private String domainName;
    private String parentDomainName;
    private boolean parentFirst;
    private ClassLoader parent;
    boolean domainDefined = false;
    boolean domainCreated = false;
    boolean deploymentCreated = false;
    private KernelDeployment kernelDeployment = null;
    private VFSClassLoaderFactory metaDataFactory;

    public CLDeploymentBuilder(String name, URL ... urls) {
        this.name = name;
        this.urls = urls;
        this.importAll = true;
    }

    public String getName() {
        return this.name;
    }

    public void setExcludes(URL ... urls) {
        this.excludes = urls;
    }

    public void setImportAll(boolean importAll) {
        this.importAll = importAll;
    }

    public void createDomain(String domain, String parentDomain, boolean parentFirst) {
        if (DomainRegistry.contains(domain)) {
            throw new IllegalStateException("Domain " + domain + " already exists");
        }
        DomainRegistry.registerDomain(domain);
        this.domainCreated = true;
        this.setDomain(domain, parentDomain, parentFirst);
    }

    public void createDomain(String domain, boolean parentFirst) {
        this.createDomain(domain, (String)null, parentFirst);
    }

    public boolean isDomainCreated() {
        return this.domainCreated;
    }

    public void createDomain(String domain, ClassLoader parent, boolean parentFirst) {
        this.createDomain(domain, (String)null, parentFirst);
        this.setParent(parent);
    }

    public void setDomain(String domainName) {
        this.setDomain(domainName, null, false);
    }

    private void setDomain(String domain, String parentDomain, boolean parentFirst) {
        if (this.domainDefined) {
            throw new IllegalStateException("Duplicate definition of domain for CLDeployment " + this.getName());
        }
        this.domainName = domain;
        this.parentDomainName = parentDomain;
        this.parentFirst = parentFirst;
        this.domainDefined = true;
    }

    public String getDomain() {
        return this.domainName;
    }

    public void setParent(ClassLoader parent) {
        this.parent = parent;
    }

    public CLDeploymentBuilder createModule(String name) {
        this.capabilities.add(clmdf.createModule(name));
        return this;
    }

    public CLDeploymentBuilder createModule(String name, Object version) {
        this.capabilities.add(clmdf.createModule(name, version));
        return this;
    }

    public CLDeploymentBuilder createRequireModule(String name) {
        this.requirements.add(clmdf.createRequireModule(name, null));
        return this;
    }

    public CLDeploymentBuilder createRequireModule(String name, VersionRange versionRange) {
        this.requirements.add(clmdf.createRequireModule(name, versionRange));
        return this;
    }

    public CLDeploymentBuilder createRequireModule(String name, VersionRange versionRange, boolean optional, boolean reExport, boolean dynamic) {
        this.requirements.add(clmdf.createRequireModule(name, versionRange, optional, reExport, dynamic));
        return this;
    }

    public CLDeploymentBuilder createPackage(String name) {
        this.capabilities.add(clmdf.createPackage(name));
        return this;
    }

    public CLDeploymentBuilder createPackage(String name, Object version) {
        this.capabilities.add(clmdf.createPackage(name, version));
        return this;
    }

    public CLDeploymentBuilder createRequirePackage(String name) {
        this.requirements.add(clmdf.createRequirePackage(name));
        return this;
    }

    public CLDeploymentBuilder createRequirePackage(String name, VersionRange versionRange) {
        this.requirements.add(clmdf.createRequirePackage(name, versionRange));
        return this;
    }

    public CLDeploymentBuilder createRequirePackage(String name, VersionRange versionRange, boolean optional, boolean reExport, boolean dynamic) {
        this.requirements.add(clmdf.createRequirePackage(name, versionRange, optional, reExport, dynamic));
        return this;
    }

    public CLDeploymentBuilder createReExportModule(String name) {
        this.requirements.add(clmdf.createReExportModule(name));
        return this;
    }

    public CLDeploymentBuilder createReExportModule(String name, VersionRange versionRange) {
        this.requirements.add(clmdf.createReExportModule(name, versionRange));
        return this;
    }

    public CLDeploymentBuilder createReExportModule(String name, VersionRange versionRange, boolean optional) {
        this.requirements.add(clmdf.createReExportModule(name, versionRange, optional));
        return this;
    }

    public CLDeploymentBuilder createReExportPackage(String name) {
        this.requirements.add(clmdf.createReExportPackage(name));
        return this;
    }

    public CLDeploymentBuilder createReExportPackage(String name, VersionRange versionRange) {
        this.requirements.add(clmdf.createReExportPackage(name, versionRange));
        return this;
    }

    public CLDeploymentBuilder createReExportPackage(String name, VersionRange versionRange, boolean optional) {
        this.requirements.add(clmdf.createReExportPackage(name, versionRange, optional));
        return this;
    }

    public CLDeploymentBuilder createUsesPackage(String name) {
        this.requirements.add(clmdf.createUsesPackage(name));
        return this;
    }

    public CLDeploymentBuilder createUsesPackage(String name, VersionRange versionRange) {
        this.requirements.add(clmdf.createUsesPackage(name, versionRange));
        return this;
    }

    public CLDeploymentBuilder createUsesPackage(String name, VersionRange versionRange, boolean reExport) {
        this.requirements.add(clmdf.createUsesPackage(name, versionRange, reExport));
        return this;
    }

    public synchronized KernelDeployment createDeployment() {
        Assert.assertFalse((String)"Duplicate deployment created", (boolean)this.deploymentCreated);
        if (this.metaDataFactory == null) {
            this.metaDataFactory = this.createMetaDataFactory();
        }
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setName(this.metaDataFactory.getName() + ":" + this.metaDataFactory.getVersion());
        deployment.setBeanFactories(Collections.singletonList(this.metaDataFactory));
        this.deploymentCreated = true;
        this.kernelDeployment = deployment;
        return deployment;
    }

    public synchronized KernelDeployment getDeployment() {
        return this.kernelDeployment;
    }

    public synchronized KernelDeployment undeploy() {
        this.deploymentCreated = false;
        return this.kernelDeployment;
    }

    public VFSClassLoaderFactory getMetaDataFactory() {
        Assert.assertNotNull((String)"MetaDataFactory can be retrieved only after deployment creation.", (Object)this.metaDataFactory);
        return this.metaDataFactory;
    }

    private VFSClassLoaderFactory createMetaDataFactory() {
        TestVFSClassLoaderFactory factory = new TestVFSClassLoaderFactory();
        factory.setName(this.name);
        factory.setImportAll(this.importAll);
        if (this.importAll) {
            factory.setExportAll(ExportAll.NON_EMPTY);
        }
        factory.setRoots(CLDeploymentBuilder.urlsToStringList(this.urls));
        factory.setExcludedRoots(CLDeploymentBuilder.urlsToStringList(this.excludes));
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            factory.getCapabilities().setCapabilities(this.capabilities);
        }
        if (this.requirements != null && !this.requirements.isEmpty()) {
            factory.getRequirements().setRequirements(this.requirements);
        }
        CLDeploymentBuilder.setupDomain((ClassLoadingMetaData)factory, this.domainName, this.parentDomainName, this.parentFirst);
        if (this.parent != null) {
            factory.setParent(this.parent);
        }
        return factory;
    }

    public ClassLoader getParent() {
        return this.parent;
    }

    private static void setupDomain(ClassLoadingMetaData md, String domainName, String parentDomainName, boolean parentFirst) {
        if (domainName != null) {
            md.setDomain(domainName);
            md.setJ2seClassLoadingCompliance(parentFirst);
            if (parentDomainName != null) {
                md.setParentDomain(parentDomainName);
            } else {
                md.setParentDomain("DefaultDomain");
            }
        } else {
            md.setDomain("DefaultDomain");
        }
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    private static List<String> urlsToStringList(URL ... urls) {
        if (urls == null) {
            return null;
        }
        ArrayList<String> urlList = new ArrayList<String>(urls.length);
        if (urls.length > 0) {
            for (URL url : urls) {
                if (url == null) continue;
                urlList.add(url.toString());
            }
        }
        return urlList;
    }
}

