/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Iterator;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.classloader.spi.filter.ClassFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredClassPool
extends ClassPool {
    private ClassPool delegate;
    private ClassFilter classFilter;

    public FilteredClassPool(ClassPool delegate, ClassFilter classFilter) {
        this.delegate = delegate;
        this.classFilter = classFilter;
    }

    public String toString() {
        return "FilteredClassPool (" + this.delegate + ")";
    }

    public void importPackage(String packageName) {
        this.delegate.importPackage(packageName);
    }

    public void clearImportedPackages() {
        if (this.delegate != null) {
            this.delegate.clearImportedPackages();
        } else {
            super.clearImportedPackages();
        }
    }

    public Iterator<?> getImportedPackages() {
        return this.delegate.getImportedPackages();
    }

    public void recordInvalidClassName(String name) {
        this.delegate.recordInvalidClassName(name);
    }

    public Object[] lookupCflow(String name) {
        return this.delegate.lookupCflow(name);
    }

    public CtClass getAndRename(String orgName, String newName) throws NotFoundException {
        return this.delegate.getAndRename(orgName, newName);
    }

    public CtClass get(String classname) throws NotFoundException {
        if (this.classFilter.matchesClassName(classname)) {
            return this.delegate.get(classname);
        }
        throw new NotFoundException(classname);
    }

    public CtClass getCtClass(String classname) throws NotFoundException {
        if (this.classFilter.matchesClassName(classname)) {
            return this.delegate.getCtClass(classname);
        }
        throw new NotFoundException(classname);
    }

    public URL find(String classname) {
        if (this.classFilter.matchesClassName(classname)) {
            return this.delegate.find(classname);
        }
        return null;
    }

    public CtClass[] get(String[] classnames) throws NotFoundException {
        for (String classname : classnames) {
            if (this.classFilter.matchesClassName(classname)) continue;
            throw new NotFoundException(classname);
        }
        return this.delegate.get(classnames);
    }

    public CtMethod getMethod(String classname, String methodname) throws NotFoundException {
        if (this.classFilter.matchesClassName(classname)) {
            return this.delegate.getMethod(classname, methodname);
        }
        throw new NotFoundException(classname);
    }

    public CtClass makeClass(InputStream classfile) throws IOException, RuntimeException {
        return this.delegate.makeClass(classfile);
    }

    public CtClass makeClass(InputStream classfile, boolean ifNotFrozen) throws IOException, RuntimeException {
        return this.delegate.makeClass(classfile, ifNotFrozen);
    }

    public CtClass makeClassIfNew(InputStream classfile) throws IOException, RuntimeException {
        return this.delegate.makeClassIfNew(classfile);
    }

    public CtClass makeClass(String classname) throws RuntimeException {
        return this.delegate.makeClass(classname);
    }

    public synchronized CtClass makeClass(String classname, CtClass superclass) throws RuntimeException {
        return this.delegate.makeClass(classname, superclass);
    }

    public CtClass makeInterface(String name) throws RuntimeException {
        return this.delegate.makeInterface(name);
    }

    public synchronized CtClass makeInterface(String name, CtClass superclass) throws RuntimeException {
        return this.delegate.makeInterface(name, superclass);
    }

    public ClassPath appendSystemPath() {
        return this.delegate.appendSystemPath();
    }

    public ClassPath insertClassPath(ClassPath cp) {
        return this.delegate.insertClassPath(cp);
    }

    public ClassPath appendClassPath(ClassPath cp) {
        return this.delegate.appendClassPath(cp);
    }

    public ClassPath insertClassPath(String pathname) throws NotFoundException {
        return this.delegate.insertClassPath(pathname);
    }

    public ClassPath appendClassPath(String pathname) throws NotFoundException {
        return this.delegate.appendClassPath(pathname);
    }

    public void removeClassPath(ClassPath cp) {
        this.delegate.removeClassPath(cp);
    }

    public void appendPathList(String pathlist) throws NotFoundException {
        this.delegate.appendPathList(pathlist);
    }

    public Class<?> toClass(CtClass clazz) throws CannotCompileException {
        return this.delegate.toClass(clazz);
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public Class<?> toClass(CtClass ct, ClassLoader loader) throws CannotCompileException {
        return this.delegate.toClass(ct, loader);
    }

    public Class<?> toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        return this.delegate.toClass(ct, loader, domain);
    }

    protected synchronized CtClass get0(String classname, boolean useCache) throws NotFoundException {
        if (this.classFilter.matchesClassName(classname)) {
            return this.delegate.getCtClass(classname);
        }
        throw new NotFoundException(classname);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || this.delegate == other;
    }
}

