/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.support;

import java.util.Collection;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.classpool.plugins.jbosscl.VFSClassLoaderDomainRegistry;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.test.AbstractTestCase;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.DomainRegistry;
import org.jboss.test.classpool.jbosscl.support.LoaderRegistry;
import org.jboss.test.classpool.jbosscl.support.MicrocontainerFacade;
import org.jboss.test.classpool.jbosscl.support.NoSuchClassLoaderException;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.support.ClassLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCLFactory
implements ClassLoaderFactory<CLDeploymentBuilder> {
    protected ClassLoaderSystem system;
    protected VFSClassLoaderDomainRegistry domainRegistry;
    private MicrocontainerFacade microcontainer;
    private LoaderRegistry loaderRegistry;

    public JBossCLFactory(MicrocontainerFacade mc) {
        this.microcontainer = mc;
        this.system = (ClassLoaderSystem)mc.getBean("ClassLoaderSystem");
        this.domainRegistry = (VFSClassLoaderDomainRegistry)mc.getBean("ClassLoaderScopingPolicy");
        this.loaderRegistry = new LoaderRegistry(mc);
    }

    public synchronized ClassLoader create(CLDeploymentBuilder classLoaderBuilder) throws Exception {
        KernelDeployment deployment = classLoaderBuilder.createDeployment();
        this.microcontainer.deploy(deployment);
        VFSClassLoaderFactory factory = classLoaderBuilder.getMetaDataFactory();
        factory.setContextName(this.getContextName(factory));
        this.loaderRegistry.registerDeployment(classLoaderBuilder);
        return this.retrieve(classLoaderBuilder);
    }

    public synchronized void destroy(CLDeploymentBuilder classLoaderBuilder) throws Exception {
        this.loaderRegistry.unregisterDeployment(classLoaderBuilder);
        this.microcontainer.undeploy(classLoaderBuilder.undeploy());
        this.isAvailable(classLoaderBuilder);
    }

    public synchronized void destroyAll() {
        this.destroyClassLoaders();
        this.unregisterDomains();
        this.assertCannotLoadSupportClasses();
    }

    public synchronized ClassLoader retrieve(CLDeploymentBuilder classLoaderBuilder) throws Exception {
        VFSClassLoaderFactory factory = classLoaderBuilder.getMetaDataFactory();
        try {
            Object obj = this.microcontainer.getBean(factory.getContextName());
            Assert.assertTrue((boolean)(obj instanceof ClassLoader));
            ClassLoader classLoader = (ClassLoader)obj;
            this.loaderRegistry.registerClassLoader(classLoader, classLoaderBuilder);
            return classLoader;
        }
        catch (IllegalStateException e) {
            throw new NoSuchClassLoaderException(e);
        }
    }

    public synchronized Collection<ClassLoader> retrieveAll() {
        return this.loaderRegistry.getClassLoaders();
    }

    public synchronized boolean isAvailable(CLDeploymentBuilder classLoaderBuilder) throws Exception {
        String name = this.getContextName(classLoaderBuilder.getMetaDataFactory());
        try {
            Object bean = this.microcontainer.getBean(name, null);
            return bean != null;
        }
        catch (Throwable t) {
            AbstractTestCase.checkThrowable(IllegalStateException.class, (Throwable)t);
            return false;
        }
    }

    private void assertCannotLoadSupportClasses() {
        ClassLoaderDomain domain = this.system.getDefaultDomain();
        for (String className : SupportClasses.getAllSupportClasses()) {
            try {
                Class clazz = domain.loadClass(className);
                if (clazz == null) continue;
                Assert.fail((String)("Should not have been able to load " + className));
            }
            catch (Exception expected) {
                // empty catch block
            }
        }
    }

    private void unregisterDomains() {
        for (Map.Entry<String, ClassLoaderDomain> entry : DomainRegistry.clear().entrySet()) {
            ClassLoaderDomain domain = entry.getValue();
            if (domain != null) {
                Logger.getLogger(AbstractTestCase.class).debug((Object)("Unregistering domain " + domain));
                ClassLoaderDomain registeredDomain = this.system.getDomain(domain.getName());
                if (registeredDomain == null) {
                    throw new IllegalStateException("Domain is not registered: " + domain.getName());
                }
                if (registeredDomain != domain) {
                    throw new IllegalStateException(domain + " is not the same as " + registeredDomain);
                }
            } else {
                domain = this.system.getDomain(entry.getKey());
                if (domain == null) continue;
            }
            this.system.unregisterDomain(domain);
        }
    }

    private void destroyClassLoaders() {
        for (ClassLoader classLoader : this.loaderRegistry.getClassLoaders()) {
            this.destroy(classLoader);
            try {
                Object bean = this.microcontainer.getBean(((BaseClassLoader)classLoader).getName(), null);
                if (bean == null) continue;
                Assert.fail((String)("Should not be here: " + bean));
            }
            catch (Throwable t) {
                AbstractTestCase.checkThrowable(IllegalStateException.class, (Throwable)t);
            }
        }
    }

    protected void destroy(ClassLoader classLoader) {
        KernelDeployment deployment = this.loaderRegistry.unregisterDeployment(classLoader);
        this.microcontainer.undeploy(deployment);
    }

    private String getContextName(VFSClassLoaderFactory factory) {
        String contextName = factory.getContextName();
        if (contextName == null) {
            contextName = factory.getName() + ":" + factory.getVersion();
        }
        return contextName;
    }
}

