/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import junit.framework.Assert;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.classpool.plugins.jbosscl.VFSClassLoaderDomainRegistry;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.test.AbstractTestCase;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.DomainRegistry;
import org.jboss.test.classpool.jbosscl.support.MicrocontainerFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoaderRegistry {
    protected ClassLoaderSystem system;
    protected VFSClassLoaderDomainRegistry domainRegistry;
    private MicrocontainerFacade microcontainer;
    private Map<ClassLoader, ClassLoaderDomain> scopedChildDomainsByLoader = new WeakHashMap<ClassLoader, ClassLoaderDomain>();
    private Map<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
    private Map<String, KernelDeployment> deploymentsByName = new HashMap<String, KernelDeployment>();

    public LoaderRegistry(MicrocontainerFacade microcontainer) {
        this.microcontainer = microcontainer;
        this.system = (ClassLoaderSystem)microcontainer.getBean("ClassLoaderSystem");
        this.domainRegistry = (VFSClassLoaderDomainRegistry)microcontainer.getBean("ClassLoaderScopingPolicy");
    }

    public synchronized void registerDeployment(CLDeploymentBuilder clDeploymentBuilder) {
        ClassLoaderDomain domain;
        KernelDeployment deployment = clDeploymentBuilder.getDeployment();
        VFSClassLoaderFactory factory = clDeploymentBuilder.getMetaDataFactory();
        this.deploymentsByName.put(factory.getContextName() + "$MODULE", deployment);
        String domainName = factory.getDomain();
        if (clDeploymentBuilder.isDomainCreated() && (domain = this.system.getDomain(domainName)) != null) {
            Logger.getLogger(AbstractTestCase.class).debug((Object)("Registering domain " + domain));
            DomainRegistry.registerDomain(domain);
            if (factory.getParentDomain() == null || factory.getParentDomain().equals("DefaultDomain")) {
                Assert.assertNull((Object)domain.getParentDomain());
            } else {
                Assert.assertNotNull((Object)domain.getParentDomainName());
                Assert.assertEquals((String)factory.getParentDomain(), (String)domain.getParentDomainName());
            }
        }
    }

    public synchronized void registerClassLoader(ClassLoader classLoader, CLDeploymentBuilder clDeploymentBuilder) {
        VFSClassLoaderFactory factory = clDeploymentBuilder.getMetaDataFactory();
        String name = factory.getContextName() + "$MODULE";
        Module module = this.microcontainer.assertBean(name, Module.class);
        this.domainRegistry.initMapsForModule(module);
        this.scopedChildDomainsByLoader.put(classLoader, this.system.getDomain(factory.getDomain()));
        this.classLoaders.put(name, classLoader);
    }

    public synchronized void unregisterDeployment(CLDeploymentBuilder clDeploymentBuilder) throws Exception {
        ClassLoaderDomain domain;
        String contextName = clDeploymentBuilder.getMetaDataFactory().getContextName();
        String name = contextName + "$MODULE";
        ClassLoader classLoader = (ClassLoader)this.microcontainer.getBean(contextName);
        this.deploymentsByName.remove(name);
        this.scopedChildDomainsByLoader.remove(classLoader);
        this.classLoaders.remove(name);
        if (clDeploymentBuilder.isDomainCreated() && (domain = this.scopedChildDomainsByLoader.get(classLoader)) != null) {
            DomainRegistry.registerDomain(domain.getName());
            this.system.unregisterDomain(domain);
        }
    }

    public synchronized KernelDeployment unregisterDeployment(ClassLoader classLoader) {
        String name = ((BaseClassLoader)classLoader).getName();
        this.classLoaders.remove(name);
        return this.deploymentsByName.remove(name);
    }

    public synchronized Collection<ClassLoader> getClassLoaders() {
        return new ArrayList<ClassLoader>(this.classLoaders.values());
    }

    public synchronized ClassLoaderDomain getDomainForClassLoader(ClassLoader loader) {
        return this.scopedChildDomainsByLoader.get(loader);
    }
}

