/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.support;

import java.util.Arrays;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloading.spi.vfs.dependency.VFSClassLoaderPolicyModule;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.test.classpool.jbosscl.support.TestVFSClassLoaderPolicyModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestVFSClassLoaderFactory
extends VFSClassLoaderFactory {
    private static final long serialVersionUID = 1L;
    private ClassLoader parent;
    private List<String> excludedRoots;

    TestVFSClassLoaderFactory() {
    }

    protected Class<? extends VFSClassLoaderPolicyModule> getModuleClass() {
        return TestVFSClassLoaderPolicyModule.class;
    }

    public void setParent(ClassLoader parent) {
        this.parent = parent;
    }

    public void setExcludedRoots(List<String> excludedRoots) {
        this.excludedRoots = excludedRoots;
    }

    public List<BeanMetaData> getBeans() {
        boolean overwriteModule;
        List<BeanMetaData> result = super.getBeans();
        boolean overwriteClassLoader = this.parent != null;
        boolean bl = overwriteModule = this.excludedRoots != null && !this.excludedRoots.isEmpty();
        if (overwriteClassLoader || overwriteModule) {
            BeanMetaDataBuilder builder;
            if (result.size() != 2) {
                throw new IllegalStateException("Expected size=2, was " + result.size());
            }
            BeanMetaData classLoader = null;
            BeanMetaData module = null;
            for (BeanMetaData bean : result) {
                if (bean.getBean().equals(ClassLoader.class.getName())) {
                    classLoader = bean;
                    continue;
                }
                module = bean;
            }
            if (module == null) {
                throw new IllegalStateException("Could not find module");
            }
            if (classLoader == null) {
                throw new IllegalStateException("Could not find module");
            }
            String moduleName = module.getName();
            if (overwriteClassLoader) {
                builder = BeanMetaDataBuilder.createBuilder((String)classLoader.getName(), (String)ClassLoader.class.getName());
                builder.setNoClassLoader();
                builder.setFactory(module.getName());
                builder.setFactoryMethod("registerClassLoaderPolicy");
                builder.addConstructorParameter(ClassLoaderSystem.class.getName(), builder.createInject((Object)this.getClassLoaderSystemName()));
                builder.addConstructorParameter(ClassLoader.class.getName(), (Object)this.parent);
                classLoader = builder.getBeanMetaData();
            }
            if (overwriteModule) {
                builder = BeanMetaDataBuilder.createBuilder((String)moduleName, (String)this.getModuleClass().getName());
                builder.addConstructorParameter(VFSClassLoaderFactory.class.getName(), (Object)this);
                builder.addConstructorParameter(String.class.getName(), moduleName);
                builder.addPropertyMetaData("roots", (Object)this.getRoots());
                builder.addPropertyMetaData("excludedRoots", this.excludedRoots);
                builder.setNoClassLoader();
                builder.addUninstall("removeClassLoader");
                module = builder.getBeanMetaData();
            }
            result = Arrays.asList(classLoader, module);
        }
        return result;
    }
}

