/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.support;

import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.classloading.spi.vfs.dependency.VFSClassLoaderPolicyModule;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.classloading.spi.vfs.policy.VFSClassLoaderPolicy;
import org.jboss.util.id.GUID;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestVFSClassLoaderPolicyModule
extends VFSClassLoaderPolicyModule {
    private static final long serialVersionUID = 1L;
    URL dynamicClassRoot;
    VirtualFile classes;
    Closeable tempDirectoryHandle;
    private List<String> excludedRoots;

    public TestVFSClassLoaderPolicyModule(VFSClassLoaderFactory classLoadingMetaData, String contextName) {
        super(classLoadingMetaData, contextName);
    }

    public void reset() {
        super.reset();
        VFSUtils.safeClose((Closeable)this.tempDirectoryHandle);
    }

    public void setExcludedRoots(List<String> excludedRoots) {
        this.excludedRoots = excludedRoots;
    }

    public URL getDynamicClassRoot() {
        this.initDynamicClassRoot();
        return this.dynamicClassRoot;
    }

    protected VirtualFile[] determineVFSRoots() {
        this.initDynamicClassRoot();
        Map<Integer, String> truncatedRootPaths = this.truncateArchiveNestedPaths(this.getRoots());
        VirtualFile[] roots = super.determineVFSRoots();
        this.restoreArchiveNestedPaths(truncatedRootPaths, roots);
        VirtualFile[] newRoots = new VirtualFile[roots.length + 1];
        newRoots[0] = this.classes;
        System.arraycopy(roots, 0, newRoots, 1, roots.length);
        return newRoots;
    }

    protected VFSClassLoaderPolicy determinePolicy() {
        VirtualFile[] roots = this.determineVFSRoots();
        VirtualFile[] excludedRoots = this.determineVFSExcludedRoots();
        VFSClassLoaderPolicy policy = VFSClassLoaderPolicy.createVFSClassLoaderPolicy((String)this.getContextName(), (VirtualFile[])roots, (VirtualFile[])excludedRoots);
        String[] packageNames = this.getPackageNames();
        policy.setExportedPackages(packageNames);
        policy.setIncluded(this.getIncluded());
        policy.setExcluded(this.getExcluded());
        policy.setExcludedExport(this.getExcludedExport());
        policy.setExportAll(this.getExportAll());
        policy.setImportAll(this.isImportAll());
        policy.setCacheable(this.isCacheable());
        policy.setBlackListable(this.isBlackListable());
        policy.setDelegates(this.getDelegates());
        return policy;
    }

    protected VirtualFile[] determineVFSExcludedRoots() {
        if (this.excludedRoots == null || this.excludedRoots.isEmpty()) {
            return new VirtualFile[0];
        }
        Map<Integer, String> truncatedRootPaths = this.truncateArchiveNestedPaths(this.excludedRoots);
        VirtualFile[] roots = this.determineVFSRoots(this.excludedRoots);
        this.restoreArchiveNestedPaths(truncatedRootPaths, roots);
        return roots;
    }

    protected VirtualFile[] determineVFSRoots(List<String> roots) {
        if (roots == null) {
            return new VirtualFile[0];
        }
        VirtualFile[] vfsRoots = new VirtualFile[roots.size()];
        for (int i = 0; i < roots.size(); ++i) {
            String root = roots.get(i);
            try {
                URI uri = new URI(root);
                vfsRoots[i] = VFS.getChild((URI)uri);
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating VFS file for " + root, e);
            }
        }
        return vfsRoots;
    }

    private synchronized void initDynamicClassRoot() {
        if (this.dynamicClassRoot == null) {
            try {
                this.classes = VFS.getChild((String)("/" + GUID.asString()));
                this.tempDirectoryHandle = VFS.mountTemp((VirtualFile)this.classes, (TempFileProvider)TempFileProvider.create((String)"classes", (ScheduledExecutorService)Executors.newScheduledThreadPool(2)));
                this.dynamicClassRoot = this.classes.toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<Integer, String> truncateArchiveNestedPaths(List<String> paths) {
        HashMap<Integer, String> truncatedRootPaths = new HashMap<Integer, String>();
        ListIterator<String> listIterator = paths.listIterator();
        while (listIterator.hasNext()) {
            int rootIndex = listIterator.nextIndex();
            String root = listIterator.next();
            int archiveIndex = root.indexOf(46);
            int lastSlash = archiveIndex > 0 ? root.indexOf(47, archiveIndex) : -1;
            if (lastSlash <= 0) continue;
            listIterator.set(root.substring(0, lastSlash));
            if ((root = root.substring(lastSlash + 1)) == null) continue;
            truncatedRootPaths.put(rootIndex, root);
        }
        return truncatedRootPaths;
    }

    private void restoreArchiveNestedPaths(Map<Integer, String> truncatedPaths, VirtualFile[] paths) {
        for (Map.Entry<Integer, String> truncatedPath : truncatedPaths.entrySet()) {
            int pathIndex = truncatedPath.getKey();
            VirtualFile file = paths[pathIndex];
            String path = truncatedPath.getValue();
            do {
                int archiveIndex;
                int lastSlash;
                int n = lastSlash = (archiveIndex = path.indexOf(46)) > 0 ? path.indexOf(47, archiveIndex) : -1;
                if (lastSlash > 0) {
                    file = file.getChild(path.substring(0, lastSlash));
                    path = path.substring(lastSlash + 1);
                    continue;
                }
                file = file.getChild(path);
                path = null;
            } while (path != null);
            paths[pathIndex] = file;
        }
    }
}

