/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveTest<C, L>
extends JBossClClassPoolTest<C, L> {
    public ArchiveTest(String name) {
        super(name);
    }

    public void testJar() throws Exception {
        CLDeploymentBuilder classLoaderBuilder = new CLDeploymentBuilder("simple.jar", SupportArchives.SIMPLE_JAR_URL);
        Object loader = this.testScenario.createLoader((ClassLoaderInfo)classLoaderBuilder);
        this.assertCanLoad(loader, SupportClasses.CLASS_PLAIN);
    }

    public void testSar() throws Exception {
        CLDeploymentBuilder classLoaderBuilder = new CLDeploymentBuilder("simple.sar", SupportArchives.SIMPLE_SAR_URL);
        Object loader = this.testScenario.createLoader((ClassLoaderInfo)classLoaderBuilder);
        this.assertCanLoad(loader, SupportClasses.CLASS_MBEAN);
    }

    public void testEjbJar() throws Exception {
        CLDeploymentBuilder classLoaderBuilder = new CLDeploymentBuilder("ejbs.jar", SupportArchives.EJB_JAR_URL);
        Object loader = this.testScenario.createLoader((ClassLoaderInfo)classLoaderBuilder);
        this.assertCanLoad(loader, SupportClasses.CLASS_SLS_BEAN, SupportClasses.CLASS_SLS_INTERFACE);
    }

    public void testWar() throws Exception {
        CLDeploymentBuilder clBuilder = new CLDeploymentBuilder("simple.war", SupportArchives.SIMPLE_WAR_CP_URL);
        clBuilder.createDomain(this.getDomain("simple.war"), false);
        Object loader = this.testScenario.createLoader((ClassLoaderInfo)clBuilder);
        this.assertCanLoad(loader, SupportClasses.CLASS_SERVLET);
    }

    public void testEar() throws Exception {
        CLDeploymentBuilder earCLBuilder = new CLDeploymentBuilder("simple.ear", SupportArchives.SIMPLE_EAR_JAR_URL, SupportArchives.SIMPLE_EAR_SAR_URL, SupportArchives.SIMPLE_EAR_EJB_URL, SupportArchives.SIMPLE_EAR_LIB1_URL, SupportArchives.SIMPLE_EAR_LIB2_URL);
        earCLBuilder.setExcludes(SupportArchives.SIMPLE_EAR_WAR1_URL, SupportArchives.SIMPLE_EAR_WAR1_CP_URL, SupportArchives.SIMPLE_EAR_WAR1_LIB_URL, SupportArchives.SIMPLE_EAR_WAR2_URL, SupportArchives.SIMPLE_EAR_WAR2_CP_URL, SupportArchives.SIMPLE_EAR_WAR2_LIB_URL);
        Object earLoader = this.testScenario.createLoader((ClassLoaderInfo)earCLBuilder);
        ClassLoader earClassLoader = this.testScenario.getClassLoader(earLoader);
        CLDeploymentBuilder war1CLBuilder = new CLDeploymentBuilder("simple.ear/simple_ui.war", SupportArchives.SIMPLE_EAR_WAR1_CP_URL, SupportArchives.SIMPLE_EAR_WAR1_LIB_URL);
        war1CLBuilder.createDomain(this.getDomain("simple.ear/simple_ui.war"), earClassLoader, false);
        Object war1Loader = this.testScenario.createLoader((ClassLoaderInfo)war1CLBuilder);
        CLDeploymentBuilder war2CLBuilder = new CLDeploymentBuilder("simple.ear/jsfapp.war", SupportArchives.SIMPLE_EAR_WAR2_CP_URL, SupportArchives.SIMPLE_EAR_WAR2_LIB_URL);
        war2CLBuilder.createDomain(this.getDomain("simple.ear/jsfapp.war"), earClassLoader, false);
        Object war2Loader = this.testScenario.createLoader((ClassLoaderInfo)war2CLBuilder);
        HashMap<String, Object> classes = new HashMap<String, Object>();
        classes.put(SupportClasses.CLASS_UTIL, earLoader);
        classes.put(SupportClasses.CLASS_EXT, earLoader);
        classes.put(SupportClasses.CLASS_PLAIN, earLoader);
        classes.put(SupportClasses.CLASS_SLS_BEAN, earLoader);
        classes.put(SupportClasses.CLASS_SLS_INTERFACE, earLoader);
        classes.put(SupportClasses.CLASS_SERVLET, war1Loader);
        classes.put(SupportClasses.CLASS_UI, war1Loader);
        classes.put(SupportClasses.CLASS_JSF, war2Loader);
        classes.put(SupportClasses.CLASS_CRM, war2Loader);
        classes.put(SupportClasses.CLASS_MBEAN, earLoader);
        this.assertCanLoad(classes);
        this.assertSimpleHierarchy(earLoader, war1Loader);
    }

    public void testTopLevelWithUtil() throws Exception {
        CLDeploymentBuilder clBuilder = new CLDeploymentBuilder("top-level.ear", SupportArchives.TOP_EAR_UTIL_URL, SupportArchives.TOP_EAR_EXT_URL);
        Object earLoader = this.testScenario.createLoader((ClassLoaderInfo)clBuilder);
        this.assertCanLoad(earLoader, SupportClasses.CLASS_UTIL, SupportClasses.CLASS_EXT);
    }

    public void testWarInEar() throws Exception {
        CLDeploymentBuilder earCLBuilder = new CLDeploymentBuilder("war-in-ear.ear", new URL[0]);
        earCLBuilder.setExcludes(SupportArchives.WAR_IN_EAR_WAR_URL, SupportArchives.WAR_IN_EAR_WAR_CP);
        Object earLoader = this.testScenario.createLoader((ClassLoaderInfo)earCLBuilder);
        CLDeploymentBuilder warCLBuilder = new CLDeploymentBuilder("war-in-ear.ear/simple.war", SupportArchives.WAR_IN_EAR_WAR_CP);
        warCLBuilder.createDomain(this.getDomain("war-in-ear.ear/simple.war"), this.testScenario.getClassLoader(earLoader), false);
        Object warLoader = this.testScenario.createLoader((ClassLoaderInfo)warCLBuilder);
        HashMap<String, Object> classes = new HashMap<String, Object>();
        classes.put(SupportClasses.CLASS_SERVLET, warLoader);
        this.assertCanLoad(classes);
    }

    public void testJarInEar() throws Exception {
        CLDeploymentBuilder earCLBuilder = new CLDeploymentBuilder("jar-in-ear.ear", SupportArchives.JAR_IN_EAR_JAR_URL);
        Object earLoader = this.testScenario.createLoader((ClassLoaderInfo)earCLBuilder);
        this.assertCanLoad(earLoader, SupportClasses.CLASS_PLAIN);
    }

    public void testIsolatedJars() throws Exception {
        CLDeploymentBuilder cl1Builder = new CLDeploymentBuilder("a.jar1", SupportArchives.JAR_A_URL);
        cl1Builder.createDomain(this.getDomain("a.jar") + 1, true);
        Object loader1 = this.testScenario.createLoader((ClassLoaderInfo)cl1Builder);
        CLDeploymentBuilder cl2Builder = new CLDeploymentBuilder("a.jar2", SupportArchives.JAR_A_URL);
        cl2Builder.createDomain(this.getDomain("a.jar") + 2, true);
        Object loader2 = this.testScenario.createLoader((ClassLoaderInfo)cl2Builder);
        this.assertIsolated(loader1, loader2);
    }

    public void testHierarchyJarsChildFirst() throws Exception {
        String domain1 = this.getDomain("a.jar") + 1;
        CLDeploymentBuilder clBuilder1 = new CLDeploymentBuilder("a.jar1", SupportArchives.JAR_A_URL);
        clBuilder1.createDomain(domain1, true);
        Object loader1 = this.testScenario.createLoader((ClassLoaderInfo)clBuilder1);
        CLDeploymentBuilder clBuilder2 = new CLDeploymentBuilder("a.jar2", SupportArchives.JAR_A_URL);
        clBuilder2.createDomain(this.getDomain("a.jar") + 2, domain1, false);
        Object loader2 = this.testScenario.createLoader((ClassLoaderInfo)clBuilder2);
        this.assertIsolated(loader1, loader2);
    }

    public void testDomainHierarchy() throws Exception {
        String topDomain = this.getDomain("simple.jar");
        CLDeploymentBuilder topCLBuilder = new CLDeploymentBuilder("simple.jar", SupportArchives.SIMPLE_JAR_URL);
        topCLBuilder.createDomain(topDomain, true);
        Object topLoader = this.testScenario.createLoader((ClassLoaderInfo)topCLBuilder);
        CLDeploymentBuilder leftCLBuilder = new CLDeploymentBuilder("servlet.jarL", SupportArchives.SERVLET_JAR_URL);
        leftCLBuilder.createDomain(this.getDomain("servlet.jar") + 'L', topDomain, true);
        Object leftLoader = this.testScenario.createLoader((ClassLoaderInfo)leftCLBuilder);
        CLDeploymentBuilder rightCLBuilder = new CLDeploymentBuilder("servlet.jarR", SupportArchives.SERVLET_JAR_URL);
        rightCLBuilder.createDomain(this.getDomain("servlet.jar") + 'R', topDomain, true);
        Object rightLoader = this.testScenario.createLoader((ClassLoaderInfo)rightCLBuilder);
        this.assertDomainHierarchy(topLoader, leftLoader, rightLoader);
    }

    public void testEar2War() throws Exception {
        String topDomain = this.getDomain("ptd-ear-1.0-SNAPSHOT.ear");
        CLDeploymentBuilder topCLBuilder = new CLDeploymentBuilder("ptd-ear-1.0-SNAPSHOT.ear", SupportArchives.PTD_EAR_LIB_URL);
        topCLBuilder.createDomain(topDomain, false);
        topCLBuilder.setExcludes(SupportArchives.PTD_JSF_WAR_URL, SupportArchives.PTD_JSF_WAR_LIB_URL, SupportArchives.PTD_WS_WAR_URL, SupportArchives.PTD_WS_WAR_LIB_URL);
        Object topLoader = this.testScenario.createLoader((ClassLoaderInfo)topCLBuilder);
        CLDeploymentBuilder leftCLBuilder = new CLDeploymentBuilder("ptd-ear-1.0-SNAPSHOT.ear/ptd-jsf-1.0-SNAPSHOT.war", SupportArchives.PTD_JSF_WAR_LIB_URL);
        leftCLBuilder.createDomain(this.getDomain("ptd-ear-1.0-SNAPSHOT.ear/ptd-jsf-1.0-SNAPSHOT.war"), topDomain, true);
        Object leftLoader = this.testScenario.createLoader((ClassLoaderInfo)leftCLBuilder);
        CLDeploymentBuilder rightCLBuilder = new CLDeploymentBuilder("ptd-ear-1.0-SNAPSHOT.ear/ptd-ws-1.0-SNAPSHOT.war", SupportArchives.PTD_WS_WAR_LIB_URL);
        rightCLBuilder.createDomain(this.getDomain("ptd-ear-1.0-SNAPSHOT.ear/ptd-ws-1.0-SNAPSHOT.war"), topDomain, true);
        Object rightLoader = this.testScenario.createLoader((ClassLoaderInfo)rightCLBuilder);
        this.assertDomainHierarchy(topLoader, leftLoader, rightLoader);
    }

    public void testJarAndExcludedClassPath() throws Exception {
        CLDeploymentBuilder jarCLBuilder = new CLDeploymentBuilder("simple.jar", SupportArchives.SIMPLE_JAR_URL);
        Object jarLoader = this.testScenario.createLoader((ClassLoaderInfo)jarCLBuilder);
        CLDeploymentBuilder anysCLBuilder = new CLDeploymentBuilder("anys-classloader", SupportArchives.EXCLUDED_CLASSPATH_URL);
        anysCLBuilder.createPackage(SupportClasses.PACKAGE_WEB);
        Object anysLoader = this.testScenario.createLoader((ClassLoaderInfo)anysCLBuilder);
        String beanName = "AnyServlet";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)SupportClasses.CLASS_SERVLET);
        builder.setClassLoader((ValueMetaData)new AbstractDependencyValueMetaData((Object)"anys-classloader:0.0.0"));
        super.deploy(builder.getBeanMetaData());
        Object anys = this.assertBean(beanName, Object.class);
        Class<?> anysClass = anys.getClass();
        ClassLoader anysCL = anysClass.getClassLoader();
        ArchiveTest.assertSame((Object)anysCL, (Object)this.testScenario.getClassLoader(anysLoader));
        ArchiveTest.assertNotSame((Object)anysCL, (Object)this.testScenario.getClassLoader(jarLoader));
        this.assertNonDeploymentModule(jarLoader, anysLoader);
    }

    public void testTifHierarchy() throws Exception {
        CLDeploymentBuilder jarCLBuilder = new CLDeploymentBuilder("simple.jar", SupportArchives.SIMPLE_JAR_URL);
        Object jarLoader = this.testScenario.createLoader((ClassLoaderInfo)jarCLBuilder);
        String anysDomain = this.getDomain("Anys");
        CLDeploymentBuilder anysCLBuilder = new CLDeploymentBuilder("anys-classloader", SupportArchives.EXCLUDED_CLASSPATH_URL);
        anysCLBuilder.createDomain(anysDomain, true);
        anysCLBuilder.createPackage(SupportClasses.PACKAGE_WEB);
        Object anysLoader = this.testScenario.createLoader((ClassLoaderInfo)anysCLBuilder);
        CLDeploymentBuilder tifCLBuilder = new CLDeploymentBuilder("tif-classloader", SupportArchives.EXCLUDED_CLASSPATH_URL);
        tifCLBuilder.createDomain(this.getDomain("TIF"), anysDomain, true);
        tifCLBuilder.createPackage(SupportClasses.PACKAGE_TIF);
        Object tifLoader = this.testScenario.createLoader((ClassLoaderInfo)tifCLBuilder);
        this.createHierarchyBeans(jarLoader);
        this.assertNonDeploymentModule(jarLoader, anysLoader, tifLoader);
    }

    public void testTifHierarchyWithRequirements() throws Exception {
        CLDeploymentBuilder jarCLBuilder = new CLDeploymentBuilder("simple.jar", SupportArchives.SIMPLE_JAR_URL);
        jarCLBuilder.createPackage(SupportClasses.PACKAGE_JAR);
        Object jarLoader = this.testScenario.createLoader((ClassLoaderInfo)jarCLBuilder);
        CLDeploymentBuilder anysCLBuilder = new CLDeploymentBuilder("anys-classloader", SupportArchives.EXCLUDED_CLASSPATH_URL);
        anysCLBuilder.createModule("any-classloader:0.0.0$Module");
        anysCLBuilder.createPackage(SupportClasses.PACKAGE_WEB);
        anysCLBuilder.createRequirePackage(SupportClasses.PACKAGE_JAR);
        Object anysLoader = this.testScenario.createLoader((ClassLoaderInfo)anysCLBuilder);
        CLDeploymentBuilder tifCLBuilder = new CLDeploymentBuilder("tif-classloader", SupportArchives.EXCLUDED_CLASSPATH_URL);
        tifCLBuilder.createModule("tif-classloader:0.0.0$Module");
        tifCLBuilder.createPackage(SupportClasses.PACKAGE_TIF);
        tifCLBuilder.createRequirePackage(SupportClasses.PACKAGE_WEB);
        Object tifLoader = this.testScenario.createLoader((ClassLoaderInfo)tifCLBuilder);
        this.createHierarchyBeans(jarLoader);
        this.assertNonDeploymentModule(jarLoader, anysLoader, tifLoader);
    }

    protected void assertCanLoad(L parentLoader, String ... classNames) throws Exception {
        HashMap<String, L> map = new HashMap<String, L>();
        for (String className : classNames) {
            map.put(className, parentLoader);
        }
        this.assertCanLoad(map);
    }

    protected void assertCanLoad(Map<String, L> classes) throws Exception {
        for (Map.Entry<String, L> entry : classes.entrySet()) {
            String className = entry.getKey();
            L loader = entry.getValue();
            this.testScenario.loadClass(loader, className);
        }
    }

    private void assertSimpleHierarchy(L topLoader, L childLoader) throws Exception {
        Object clazz = this.testScenario.loadClass(childLoader, SupportClasses.CLASS_SERVLET);
        Object returnClass = this.testScenario.getMethodReturnType(clazz, "getBean");
        Object returnClass2 = this.testScenario.loadClass(topLoader, SupportClasses.CLASS_PLAIN);
        ArchiveTest.assertSame((Object)returnClass, (Object)returnClass2);
    }

    protected void assertIsolated(L loader1, L loader2) throws Exception {
        ArchiveTest.assertFalse((boolean)loader1.equals(loader2));
        Object class1 = this.testScenario.loadClass(loader1, SupportClasses.CLASS_A);
        Object class2 = this.testScenario.loadClass(loader2, SupportClasses.CLASS_A);
        ArchiveTest.assertNotSame((String)("Should NOT be the same " + class1 + " and " + class2), (Object)class1, (Object)class2);
        Object loader3 = this.testScenario.getLoader(class1);
        Object class3 = this.testScenario.loadClass(loader3, SupportClasses.CLASS_A);
        ArchiveTest.assertEquals((Object)class1, (Object)class3);
        Object loader4 = this.testScenario.getLoader(class2);
        Object class4 = this.testScenario.loadClass(loader4, SupportClasses.CLASS_A);
        ArchiveTest.assertEquals((Object)class2, (Object)class4);
        ArchiveTest.assertNotSame((Object)class3, (Object)class4);
    }

    protected void assertDomainHierarchy(L topLoader, L leftLoader, L rightLoader) throws Exception {
        Object servletClassLeft = this.testScenario.loadClass(leftLoader, SupportClasses.CLASS_SERVLET);
        Object servletClassRight = this.testScenario.loadClass(rightLoader, SupportClasses.CLASS_SERVLET);
        ArchiveTest.assertFalse((boolean)servletClassLeft.equals(servletClassRight));
        Object plainClassLeft = this.testScenario.loadClass(leftLoader, topLoader, SupportClasses.CLASS_PLAIN);
        Object plainClassRight = this.testScenario.loadClass(rightLoader, topLoader, SupportClasses.CLASS_PLAIN);
        ArchiveTest.assertEquals((Object)plainClassLeft, (Object)plainClassRight);
        Object plainClass = this.testScenario.loadClass(topLoader, SupportClasses.CLASS_PLAIN);
        Object returnClassLeft = this.testScenario.getMethodReturnType(servletClassLeft, "getBean");
        ArchiveTest.assertEquals((Object)plainClass, (Object)returnClassLeft);
        Object returnClassRight = this.testScenario.getMethodReturnType(servletClassRight, "getBean");
        ArchiveTest.assertEquals((Object)plainClass, (Object)returnClassRight);
    }

    protected void assertNonDeploymentModule(L jarLoader, L anysLoader) throws Exception {
        Object anysClass = this.testScenario.loadClass(jarLoader, anysLoader, SupportClasses.CLASS_SERVLET);
        Object plainClass = this.testScenario.loadClass(anysLoader, jarLoader, SupportClasses.CLASS_PLAIN);
        Object returnC = this.testScenario.getMethodReturnType(anysClass, "getBean");
        ArchiveTest.assertEquals((Object)plainClass, (Object)returnC);
    }

    protected void assertNonDeploymentModule(L loader, L anysLoader, L tifLoader) throws Exception {
        Object tifClass = this.testScenario.loadClass(tifLoader, SupportClasses.CLASS_TIF);
        Object tifReturn = this.testScenario.getMethodReturnType(tifClass, "getAnys");
        Object servletClass = this.testScenario.loadClass(anysLoader, SupportClasses.CLASS_SERVLET);
        ArchiveTest.assertEquals((Object)tifReturn, (Object)servletClass);
        Object plainClass = this.testScenario.loadClass(loader, SupportClasses.CLASS_PLAIN);
        Object plainReturn = this.testScenario.getMethodReturnType(servletClass, "getBean");
        ArchiveTest.assertEquals((Object)plainClass, (Object)plainReturn);
    }

    private void createHierarchyBeans(L jarLoader) throws Exception {
        String servletName = "AnyServlet";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)servletName, (String)SupportClasses.CLASS_SERVLET);
        builder.setClassLoader((ValueMetaData)new AbstractDependencyValueMetaData((Object)"anys-classloader:0.0.0"));
        super.deploy(builder.getBeanMetaData());
        String tifName = "TifTester";
        builder = BeanMetaDataBuilder.createBuilder((String)tifName, (String)SupportClasses.CLASS_TIF);
        builder.setClassLoader((ValueMetaData)new AbstractDependencyValueMetaData((Object)"tif-classloader:0.0.0"));
        super.deploy(builder.getBeanMetaData());
        Object anys = this.assertBean(servletName, Object.class);
        Class<?> anysClass = anys.getClass();
        ClassLoader anysCL = anysClass.getClassLoader();
        Object tif = this.assertBean(tifName, Object.class);
        Class<?> tifClass = tif.getClass();
        ClassLoader tifCL = tifClass.getClassLoader();
        ClassLoader jarCL = this.testScenario.getClassLoader(jarLoader);
        ArchiveTest.assertNotSame((Object)jarCL, (Object)anysCL);
        ArchiveTest.assertNotSame((Object)jarCL, (Object)tifCL);
        ArchiveTest.assertNotSame((Object)anysCL, (Object)tifCL);
    }

    private String getDomain(String name) {
        return name + "_Domain";
    }
}

