/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classpool.plugins.jbosscl.JBossClClassPoolConfig;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTestDelegate;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.ClassPoolTestScenario;
import org.jboss.test.classpool.support.TestScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigClassPoolTestCase
extends JBossClClassPoolTest<CtClass, ClassPool> {
    private Collection<ClassLoader> createdURLClassLoaders = new HashSet<ClassLoader>();

    public ConfigClassPoolTestCase(String name) {
        super(name);
    }

    public static NoClassloadingTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new NoClassloadingTestDelegate(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            this.createdURLClassLoaders.clear();
        }
    }

    @Override
    protected NoClassloadingTestDelegate getDelegate() {
        return (NoClassloadingTestDelegate)super.getDelegate();
    }

    @Override
    protected ClassLoaderSystem getClassLoaderSystemBean() {
        return null;
    }

    @Override
    protected TestScenario<CtClass, ClassPool, CLDeploymentBuilder> getTestScenario() {
        return null;
    }

    public void testBootstrap() throws Exception {
        JBossClClassPoolConfig config = JBossClClassPoolConfig.getInstance();
        ConfigClassPoolTestCase.assertNotNull((Object)config.getClassPoolFactory());
        ConfigClassPoolTestCase.assertNotNull((Object)config.getClassPoolRepository());
        ConfigClassPoolTestCase.assertNotNull((Object)config.getDomainRegistry());
        ConfigClassPoolTestCase.assertNotNull((Object)config.getRegisterModuleCallback());
        ConfigClassPoolTestCase.assertNull((Object)config.getClassLoading());
        ClassLoader urlCl = this.createChildURLLoader(null, SupportArchives.JAR_A_URL);
        ConfigClassPoolTestCase.assertNotNull((Object)urlCl);
        ClassPool urlPool = config.getClassPoolRepository().registerClassLoader(urlCl);
        ConfigClassPoolTestCase.assertNotNull((Object)urlPool);
        CtClass aUrl = urlPool.get(SupportClasses.CLASS_A);
        CtClass stringUrl = urlPool.get(String.class.getName());
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"JBossClClassPoolConfig", (String)JBossClClassPoolConfig.class.getName());
        builder.setFactoryClass(JBossClClassPoolConfig.class.getName());
        builder.setFactoryMethod("getInstance");
        ValueMetaData inject = builder.createContextualInject(null, null, AutowireType.BY_NAME, InjectOption.CALLBACK);
        ((AbstractInjectionValueMetaData)inject).setValue((Object)"ClassLoading");
        builder.addPropertyMetaData("classLoading", inject);
        this.getDelegate().deploy(builder.getBeanMetaData());
        this.getDelegate().deployCommon();
        ConfigClassPoolTestCase.assertNotNull((Object)config.getClassLoading());
        this.testScenario = new ClassPoolTestScenario(this.getClassLoaderFactory(), config.getClassPoolRepository());
        ClassPool poolA = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL));
        CtClass aDomain = poolA.get(SupportClasses.CLASS_A);
        ConfigClassPoolTestCase.assertNotSame((Object)aUrl, (Object)aDomain);
        ConfigClassPoolTestCase.assertSame((Object)stringUrl, (Object)poolA.get(String.class.getName()));
        ClassPool poolB = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL));
        ConfigClassPoolTestCase.assertSame((Object)aDomain, (Object)poolB.get(SupportClasses.CLASS_A));
    }

    protected ClassLoader createChildURLLoader(ClassLoader parentClassLoader, URL url) {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, parentClassLoader);
        return classLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoClassloadingTestDelegate
    extends JBossClClassPoolTestDelegate {
        public NoClassloadingTestDelegate(Class<?> clazz) throws Exception {
            super(clazz);
        }

        @Override
        protected void deploy() throws Exception {
        }

        protected void deployCommon() throws Exception {
            super.deploy();
        }

        protected KernelControllerContext deploy(BeanMetaData beanMetaData) throws Exception {
            return super.deploy(beanMetaData);
        }
    }
}

