/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import java.util.ArrayList;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassFactory;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.ClassPoolTestScenario;
import org.jboss.test.classpool.support.TestScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtClassCreationTestCase
extends JBossClClassPoolTest<CtClass, ClassPool> {
    public CtClassCreationTestCase(String name) {
        super(name);
    }

    @Override
    protected TestScenario<CtClass, ClassPool, CLDeploymentBuilder> getTestScenario() {
        return new ClassPoolTestScenario(this.getClassLoaderFactory(), this.getClassPoolRepository());
    }

    public void testCreatedClassInSamePackage() throws Exception {
        ClassPool poolA = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL));
        ClassPool poolB = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL));
        ClassLoader loaderA = poolA.getClassLoader();
        ClassLoader loaderB = poolB.getClassLoader();
        Class<?> classA = loaderA.loadClass(SupportClasses.CLASS_A);
        Class<?> classB = loaderB.loadClass(SupportClasses.CLASS_B);
        ClassPoolRepository repository = this.getClassPoolRepository();
        Object createdA = ClassFactory.create(classA, (ClassLoader)loaderA, (ClassPoolRepository)repository);
        Object createdB = ClassFactory.create(classB, (ClassLoader)loaderB, (ClassPoolRepository)repository);
        Class<?> createdClassA = createdA.getClass();
        Class<?> createdClassB = createdB.getClass();
        CtClassCreationTestCase.assertTrue((boolean)classA.isAssignableFrom(createdClassA));
        CtClassCreationTestCase.assertTrue((boolean)classB.isAssignableFrom(createdClassB));
        CtClassCreationTestCase.assertTrue((boolean)createdClassA.getName().startsWith(SupportClasses.PACKAGE_A));
        CtClassCreationTestCase.assertTrue((boolean)createdClassB.getName().startsWith(SupportClasses.PACKAGE_B));
        CtClassCreationTestCase.assertSame(createdClassA, loaderA.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderA.loadClass(createdClassB.getName()));
        CtClassCreationTestCase.assertSame(createdClassA, loaderB.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderB.loadClass(createdClassB.getName()));
    }

    public void testCreateClassForSystemClass() throws Exception {
        CLDeploymentBuilder clBuilderA = new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL);
        clBuilderA.createModule("ModuleA").createPackage(SupportClasses.PACKAGE_A);
        clBuilderA.createPackage("org.test.classpool.proxy").setImportAll(true);
        ClassPool poolA = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)clBuilderA);
        CLDeploymentBuilder clBuilderB = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        clBuilderB.createModule("ModuleB").createPackage(SupportClasses.PACKAGE_B);
        clBuilderB.createPackage("org.test.classpool.proxy").setImportAll(true);
        ClassPool poolB = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)clBuilderB);
        ClassLoader loaderA = poolA.getClassLoader();
        ClassLoader loaderB = poolB.getClassLoader();
        ClassPoolRepository repository = this.getClassPoolRepository();
        Object createdA = ClassFactory.create(ArrayList.class, (ClassLoader)loaderA, (ClassPoolRepository)repository);
        Object createdB = ClassFactory.create(ArrayList.class, (ClassLoader)loaderB, (ClassPoolRepository)repository);
        Class<?> createdClassA = createdA.getClass();
        Class<?> createdClassB = createdB.getClass();
        CtClassCreationTestCase.assertTrue((boolean)ArrayList.class.isAssignableFrom(createdClassA));
        CtClassCreationTestCase.assertTrue((boolean)ArrayList.class.isAssignableFrom(createdClassB));
        CtClassCreationTestCase.assertTrue((boolean)createdClassA.getName().startsWith("org.test.classpool.proxy"));
        CtClassCreationTestCase.assertTrue((boolean)createdClassB.getName().startsWith("org.test.classpool.proxy"));
        CtClassCreationTestCase.assertSame(createdClassA, loaderA.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderA.loadClass(createdClassB.getName()));
        CtClassCreationTestCase.assertSame(createdClassA, loaderB.loadClass(createdClassA.getName()));
        CtClassCreationTestCase.assertSame(createdClassB, loaderB.loadClass(createdClassB.getName()));
    }
}

