/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.NoSuchClassLoaderException;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DependencyTest<C, L>
extends JBossClClassPoolTest<C, L> {
    public DependencyTest(String name) {
        super(name);
    }

    public void testImportNoVersionCheck() throws Exception {
        CLDeploymentBuilder clBuilderA = this.createExportCLBuilder("A");
        CLDeploymentBuilder clBuilderB = this.createRequireCLBuilder();
        this.assertRequiredModule(clBuilderA, clBuilderB);
    }

    public void testImportVersionCheck() throws Exception {
        CLDeploymentBuilder clBuilderA = this.createExportCLBuilder("A", "1.0.0");
        CLDeploymentBuilder clBuilderB = this.createRequireCLBuilder(new VersionRange((Object)"1.0.0", (Object)"2.0.0"));
        this.assertRequiredModule(clBuilderA, clBuilderB);
    }

    public void testImportVersionCheckFailed() throws Exception {
        CLDeploymentBuilder clBuilderA = this.createExportCLBuilder("A", "3.0.0");
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)clBuilderA);
        Object classA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        CLDeploymentBuilder clBuilderB = this.createRequireCLBuilder(new VersionRange((Object)"1.0.0", (Object)"2.0.0"));
        try {
            this.testScenario.createLoader((ClassLoaderInfo)clBuilderB);
            DependencyTest.fail((String)"Should not have been able to create loader");
        }
        catch (NoSuchClassLoaderException expected) {
            // empty catch block
        }
        this.testScenario.cannotGetLoader((ClassLoaderInfo)clBuilderB);
        Object classA1 = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)classA, (Object)classA1);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
    }

    public abstract void testSeveralModulesWithSamePackages() throws Exception;

    public void testSeveralModulesWithSamePackages(String exporterLoader) throws Exception {
        CLDeploymentBuilder clAModuleXBuilder = this.createExportCLBuilder("X");
        CLDeploymentBuilder clAModuleABuilder = this.createExportCLBuilder("A");
        CLDeploymentBuilder clAModuleYBuilder = this.createExportCLBuilder("Y");
        CLDeploymentBuilder clBuilderB = this.createRequireCLBuilder();
        int exporterLoaderIndex = 0;
        if (exporterLoader.equals("X")) {
            exporterLoaderIndex = 1;
        } else if (exporterLoader.equals("A")) {
            exporterLoaderIndex = 2;
        } else if (exporterLoader.equals("Y")) {
            exporterLoaderIndex = 3;
        } else {
            throw new IllegalStateException("Exporter loader should be one of: \"X\", \"A\" or \"Y\"");
        }
        this.assertRequireModule(clAModuleXBuilder, clAModuleABuilder, clAModuleYBuilder, clBuilderB, exporterLoaderIndex);
    }

    public void testSeveralModulesWithSameNamesDifferentVersions() throws Exception {
        CLDeploymentBuilder clAModuleA1Builder = this.createExportCLBuilder("X", "1.0.0");
        CLDeploymentBuilder clAModuleA2Builder = this.createExportCLBuilder("A", "2.0.0");
        CLDeploymentBuilder clAModuleA3Builder = this.createExportCLBuilder("Y", "3.0.0");
        CLDeploymentBuilder clBuilderB = this.createRequireCLBuilder(new VersionRange((Object)"2.0.0", true, (Object)"3.0.0", false));
        this.assertRequireModule(clAModuleA1Builder, clAModuleA2Builder, clAModuleA3Builder, clBuilderB, 2);
    }

    private void assertRequiredModule(CLDeploymentBuilder clBuilderA, CLDeploymentBuilder clBuilderB) throws NoSuchClassLoaderException, Exception {
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)clBuilderA);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        Object aFromA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)clBuilderB);
        Object aFromA1 = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)aFromA, (Object)aFromA1);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        Object aFromB = this.testScenario.loadClass(loaderB, loaderA, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)aFromA, (Object)aFromB);
        this.testScenario.destroyLoader((ClassLoaderInfo)clBuilderB);
        aFromA1 = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)aFromA, (Object)aFromA1);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
    }

    private void assertRequireModule(CLDeploymentBuilder moduleBuilder1, CLDeploymentBuilder moduleBuilder2, CLDeploymentBuilder moduleBuilder3, CLDeploymentBuilder clBuilder, int exporterModule) throws NoSuchClassLoaderException, Exception {
        Object moduleLoader1 = this.testScenario.createLoader((ClassLoaderInfo)moduleBuilder1);
        Object moduleLoader2 = this.testScenario.createLoader((ClassLoaderInfo)moduleBuilder2);
        Object moduleLoader3 = this.testScenario.createLoader((ClassLoaderInfo)moduleBuilder3);
        Object classA1 = this.testScenario.loadClass(moduleLoader1, SupportClasses.CLASS_A);
        Object classA2 = this.testScenario.loadClass(moduleLoader2, SupportClasses.CLASS_A);
        Object classA3 = this.testScenario.loadClass(moduleLoader3, SupportClasses.CLASS_A);
        this.testScenario.cannotLoadClass(moduleLoader1, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(moduleLoader2, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(moduleLoader3, SupportClasses.CLASS_B);
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)clBuilder);
        Object classA1_ = this.testScenario.loadClass(moduleLoader1, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)classA1, (Object)classA1_);
        Object classA2_ = this.testScenario.loadClass(moduleLoader2, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)classA2, (Object)classA2_);
        Object classA3_ = this.testScenario.loadClass(moduleLoader3, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)classA3, (Object)classA3_);
        this.testScenario.cannotLoadClass(moduleLoader1, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(moduleLoader2, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(moduleLoader3, SupportClasses.CLASS_B);
        this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        Object exporterLoader = null;
        Object exporterLoaderClass = null;
        switch (exporterModule) {
            case 1: {
                exporterLoader = moduleLoader1;
                exporterLoaderClass = classA1;
                break;
            }
            case 2: {
                exporterLoader = moduleLoader2;
                exporterLoaderClass = classA2;
                break;
            }
            case 3: {
                exporterLoader = moduleLoader3;
                exporterLoaderClass = classA3;
                break;
            }
            default: {
                throw new IllegalStateException("Exporter loader should range from 1 to 3");
            }
        }
        Object aFromB = this.testScenario.loadClass(loaderB, exporterLoader, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)aFromB, (Object)exporterLoaderClass);
        this.testScenario.destroyLoader((ClassLoaderInfo)clBuilder);
        classA1_ = this.testScenario.loadClass(moduleLoader1, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)classA1, (Object)classA1_);
        classA2_ = this.testScenario.loadClass(moduleLoader2, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)classA2, (Object)classA2_);
        classA3_ = this.testScenario.loadClass(moduleLoader3, SupportClasses.CLASS_A);
        DependencyTest.assertSame((Object)classA3, (Object)classA3_);
        this.testScenario.cannotLoadClass(moduleLoader1, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(moduleLoader2, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(moduleLoader3, SupportClasses.CLASS_B);
    }

    private CLDeploymentBuilder createExportCLBuilder(String name) {
        return this.createExportCLBuilder(name, null);
    }

    private CLDeploymentBuilder createExportCLBuilder(String name, String version) {
        CLDeploymentBuilder clBuilderA = new CLDeploymentBuilder(name, SupportArchives.JAR_A_URL);
        this.createExportCapabilities(clBuilderA, "Module" + name, version);
        return clBuilderA;
    }

    protected abstract void createExportCapabilities(CLDeploymentBuilder var1, String var2, String var3);

    private CLDeploymentBuilder createRequireCLBuilder() {
        return this.createRequireCLBuilder(null);
    }

    private CLDeploymentBuilder createRequireCLBuilder(VersionRange requiredVersion) {
        CLDeploymentBuilder clBuilderB = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        this.createRequireCapabilities(clBuilderB, requiredVersion);
        return clBuilderB;
    }

    protected abstract void createRequireCapabilities(CLDeploymentBuilder var1, VersionRange var2);
}

