/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.NoSuchClassLoaderException;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HierarchicalDomainTest<C, L>
extends JBossClClassPoolTest<C, L> {
    private static final String PARENT_DOMAIN = "ParentDomain";
    private static final String CHILD_DOMAIN = "ChildDomain";

    public HierarchicalDomainTest(String name) {
        super(name);
    }

    public void testParentFirst() throws Exception {
        this.testParentTwoChildren(true, false);
    }

    public void testParentFirstImportAll() throws Exception {
        this.testParentTwoChildren(true, true);
    }

    public void testParentLast() throws Exception {
        this.testParentTwoChildren(false, false);
    }

    public void testParentLastImportAll() throws Exception {
        this.testParentTwoChildren(false, true);
    }

    public void testParentLastNotInChild() throws Exception {
        CLDeploymentBuilder parentCLBuilder = this.createParentCLBuilder();
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        CLDeploymentBuilder childCLBuilder = this.createChildCLBuilder(false, "DefaultDomain");
        Object childLoader = this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.assertHierarchicalDomain(parentLoader, childLoader);
    }

    public void testParentFirstWrongWayAround() throws Exception {
        this.testParentWrongWayAround(true);
    }

    public void testParentLastWrongWayAround() throws Exception {
        this.testParentWrongWayAround(false);
    }

    public void testParentRedeploy() throws Exception {
        CLDeploymentBuilder childCLBuilder = this.createChildCLBuilder(true, "DefaultDomain");
        try {
            this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
            HierarchicalDomainTest.fail((String)"Should be no loader");
        }
        catch (NoSuchClassLoaderException e) {
            // empty catch block
        }
        this.testScenario.cannotGetLoader((ClassLoaderInfo)childCLBuilder);
        CLDeploymentBuilder parentCLBuilder = this.createParentCLBuilder();
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        Object childLoader = this.testScenario.getLoader((ClassLoaderInfo)childCLBuilder);
        this.assertHierarchicalDomain(parentLoader, childLoader);
        this.assertRedeploy(childCLBuilder, parentCLBuilder);
    }

    public void testParentOtherDomain() throws Exception {
        CLDeploymentBuilder parentCLBuilder = this.createParentCLBuilderWithDomain();
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        CLDeploymentBuilder childCLBuilder = this.createChildCLBuilder(true, PARENT_DOMAIN);
        Object childLoader = this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.assertHierarchicalDomain(parentLoader, childLoader);
    }

    public void testParentOtherDomainLazy() throws Exception {
        CLDeploymentBuilder childCLBuilder = this.createChildCLBuilder(true, PARENT_DOMAIN);
        try {
            this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
            HierarchicalDomainTest.fail((String)"Should be no loader");
        }
        catch (NoSuchClassLoaderException e) {
            // empty catch block
        }
        this.testScenario.cannotGetLoader((ClassLoaderInfo)childCLBuilder);
        CLDeploymentBuilder parentCLBuilder = this.createParentCLBuilderWithDomain();
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        Object childLoader = this.testScenario.getLoader((ClassLoaderInfo)childCLBuilder);
        this.assertHierarchicalDomain(parentLoader, childLoader);
    }

    public void testParentRedeployOtherDomain() throws Exception {
        CLDeploymentBuilder childCLBuilder = this.createChildCLBuilder(true, PARENT_DOMAIN);
        try {
            this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
            HierarchicalDomainTest.fail((String)"Should be no loader");
        }
        catch (NoSuchClassLoaderException e) {
            // empty catch block
        }
        this.testScenario.cannotGetLoader((ClassLoaderInfo)childCLBuilder);
        CLDeploymentBuilder parentCLBuilder = this.createParentCLBuilderWithDomain();
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        Object childLoader = this.testScenario.getLoader((ClassLoaderInfo)childCLBuilder);
        this.assertHierarchicalDomain(parentLoader, childLoader);
        this.assertRedeploy(childCLBuilder, parentCLBuilder);
    }

    private void testParentTwoChildren(boolean parentFirst, boolean childImportAll) throws NoSuchClassLoaderException, Exception {
        CLDeploymentBuilder parentCLBuilder = this.createParentCLBuilder();
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        CLDeploymentBuilder childCLBuilderA = new CLDeploymentBuilder("aChild", SupportArchives.JAR_A_URL);
        childCLBuilderA.createDomain(CHILD_DOMAIN, parentFirst);
        Object childLoaderA = this.testScenario.createLoader((ClassLoaderInfo)childCLBuilderA);
        this.assertCanLoadAButNotB(parentLoader);
        if (parentFirst) {
            this.assertCanLoadAButNotB(childLoaderA, parentLoader);
        } else {
            this.assertCanLoadAButNotB(childLoaderA);
        }
        CLDeploymentBuilder childCLBuilderB = this.createChildCLBuilder(childImportAll);
        Object childLoaderB = this.testScenario.createLoader((ClassLoaderInfo)childCLBuilderB);
        if (parentFirst) {
            this.testScenario.loadClass(childLoaderA, parentLoader, SupportClasses.CLASS_A);
        } else {
            this.testScenario.loadClass(childLoaderA, SupportClasses.CLASS_A);
        }
        if (childImportAll) {
            this.testScenario.loadClass(childLoaderA, childLoaderB, SupportClasses.CLASS_B);
        } else {
            this.testScenario.cannotLoadClass(childLoaderA, SupportClasses.CLASS_B);
        }
        this.testScenario.loadClass(childLoaderB, SupportClasses.CLASS_B);
        this.testScenario.loadClass(childLoaderB, parentFirst ? parentLoader : childLoaderA, SupportClasses.CLASS_A);
    }

    private void testParentWrongWayAround(boolean parentFirst) throws Exception {
        CLDeploymentBuilder childBuilder = this.createChildCLBuilder(parentFirst, "DefaultDomain");
        try {
            this.testScenario.createLoader((ClassLoaderInfo)childBuilder);
            HierarchicalDomainTest.fail((String)"Should be no loader");
        }
        catch (NoSuchClassLoaderException e) {
            // empty catch block
        }
        this.testScenario.cannotGetLoader((ClassLoaderInfo)childBuilder);
        CLDeploymentBuilder parentBuilder = this.createParentCLBuilder();
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        Object childLoader = this.testScenario.getLoader((ClassLoaderInfo)childBuilder);
        this.assertHierarchicalDomain(parentLoader, childLoader);
    }

    private void assertRedeploy(CLDeploymentBuilder childCLBuilder, CLDeploymentBuilder parentCLBuilder) throws NoSuchClassLoaderException, Exception {
        this.testScenario.destroyLoader((ClassLoaderInfo)parentCLBuilder);
        this.testScenario.cannotGetLoader((ClassLoaderInfo)parentCLBuilder);
        this.testScenario.cannotGetLoader((ClassLoaderInfo)childCLBuilder);
        Object parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        this.assertCanLoadAButNotB(parentLoader);
        Object childLoader = this.testScenario.getLoader((ClassLoaderInfo)childCLBuilder);
        this.assertHierarchicalDomain(parentLoader, childLoader);
    }

    private CLDeploymentBuilder createParentCLBuilder() {
        return new CLDeploymentBuilder("aParent", SupportArchives.JAR_A_URL);
    }

    private CLDeploymentBuilder createParentCLBuilderWithDomain() {
        CLDeploymentBuilder parentCLBuilder = this.createParentCLBuilder();
        parentCLBuilder.createDomain(PARENT_DOMAIN, true);
        return parentCLBuilder;
    }

    private CLDeploymentBuilder createChildCLBuilder(boolean importAll) {
        CLDeploymentBuilder childCLBuilderB = new CLDeploymentBuilder("b", SupportArchives.JAR_B_URL);
        childCLBuilderB.setDomain(CHILD_DOMAIN);
        childCLBuilderB.createRequirePackage(SupportClasses.PACKAGE_A);
        childCLBuilderB.setImportAll(importAll);
        return childCLBuilderB;
    }

    private CLDeploymentBuilder createChildCLBuilder(boolean parentFirst, String parentDomain) {
        CLDeploymentBuilder childBuilder = new CLDeploymentBuilder("b", SupportArchives.JAR_B_URL);
        childBuilder.createDomain(CHILD_DOMAIN, parentDomain, parentFirst);
        childBuilder.createRequirePackage(SupportClasses.PACKAGE_A);
        childBuilder.setImportAll(false);
        return childBuilder;
    }

    private void assertCanLoadAButNotB(L parentLoader) throws Exception {
        this.assertCanLoadAButNotB(parentLoader, parentLoader);
    }

    private void assertCanLoadAButNotB(L parentLoader, L actualLoader) throws Exception {
        this.testScenario.loadClass(parentLoader, actualLoader, SupportClasses.CLASS_A);
        this.testScenario.cannotLoadClass(parentLoader, SupportClasses.CLASS_B);
    }

    private void assertHierarchicalDomain(L parentLoader, L childLoader) throws Exception {
        this.assertCanLoadAButNotB(parentLoader);
        this.testScenario.loadClass(childLoader, SupportClasses.CLASS_B);
        this.testScenario.loadClass(childLoader, parentLoader, SupportClasses.CLASS_A);
    }
}

