/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import java.net.URL;
import org.jboss.classloader.spi.ClassLoaderDomain;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.DomainRegistry;
import org.jboss.test.classpool.jbosscl.support.NoMatchClassFilter;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HierarchicalParentLoaderTest<C, L>
extends JBossClClassPoolTest<C, L> {
    public HierarchicalParentLoaderTest(String name) {
        super(name);
    }

    public void testHierarchyBefore() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.BEFORE, true);
    }

    public void testHierarchyBeforeNotFound() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.BEFORE, false, false);
    }

    public void testHierarchyAfterNotReached() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.AFTER_BUT_JAVA_BEFORE, false);
    }

    public void testHierarchyAfterReached() throws Exception {
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, ParentPolicy.AFTER_BUT_JAVA_BEFORE, null, true);
    }

    public void testHierarchyFiltered() throws Exception {
        NoMatchClassFilter filter = new NoMatchClassFilter(SupportClasses.CLASS_A);
        this.runTest(ParentPolicy.BEFORE_BUT_JAVA_ONLY, new ParentPolicy((ClassFilter)filter, ClassFilterUtils.NOTHING), false);
        HierarchicalParentLoaderTest.assertTrue((String)"Should have been filtered", (boolean)filter.filtered);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, true, SupportArchives.JAR_A_URL, expectedParent);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean createParent, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, createParent, SupportArchives.JAR_A_URL, expectedParent);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, URL url, boolean expectedParent) throws Exception {
        this.runTest(parentParentPolicy, childParentPolicy, true, url, expectedParent);
    }

    private void runTest(ParentPolicy parentParentPolicy, ParentPolicy childParentPolicy, boolean createParent, URL childURL, boolean expectedParent) throws Exception {
        String parentName = "parent";
        String childName = "child";
        ClassLoaderDomain parent = this.system.createAndRegisterDomain("parent", parentParentPolicy);
        DomainRegistry.registerDomain(parent);
        ClassLoaderDomain child = this.system.createAndRegisterDomain("child", childParentPolicy, (Loader)parent);
        DomainRegistry.registerDomain(child);
        Object parentLoader = null;
        if (createParent) {
            CLDeploymentBuilder parentCLBuilder = new CLDeploymentBuilder("ParentLoader", SupportArchives.JAR_A_URL);
            parentCLBuilder.setDomain("parent");
            parentLoader = this.testScenario.createLoader((ClassLoaderInfo)parentCLBuilder);
        }
        CLDeploymentBuilder childCLBuilder = new CLDeploymentBuilder("ChildLoader", childURL);
        childCLBuilder.setDomain("child");
        Object childLoader = this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.testScenario.loadClass(childLoader, expectedParent ? parentLoader : childLoader, SupportClasses.CLASS_A);
    }
}

