/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import junit.framework.Test;
import org.jboss.classloader.plugins.jdk.AbstractJDKChecker;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.JBossCLFactory;
import org.jboss.test.classpool.jbosscl.support.MicrocontainerFacade;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTestDelegate;
import org.jboss.test.classpool.support.ClassLoaderFactory;
import org.jboss.test.classpool.support.TestScenario;
import org.jboss.test.kernel.junit.MicrocontainerTest;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBossClClassPoolTest<C, L>
extends MicrocontainerTest {
    protected ClassLoaderSystem system;
    protected TestScenario<C, L, CLDeploymentBuilder> testScenario;
    private final List<Closeable> mountHandles = new LinkedList<Closeable>();

    public static JBossClClassPoolTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new JBossClClassPoolTestDelegate(clazz);
    }

    protected JBossClClassPoolTestDelegate getDelegate() {
        return (JBossClClassPoolTestDelegate)super.getDelegate();
    }

    public static Test suite(Class<?> clazz) {
        return AbstractTestCaseWithSetup.suite(clazz);
    }

    public JBossClClassPoolTest(String name) {
        super(name);
    }

    protected abstract TestScenario<C, L, CLDeploymentBuilder> getTestScenario();

    protected void setUp() throws Exception {
        super.setUp();
        this.mountJars(SupportArchives.getAllArchives());
        Set excluded = AbstractJDKChecker.getExcluded();
        excluded.add(TestScenario.class);
        this.system = this.getClassLoaderSystemBean();
        this.testScenario = this.getTestScenario();
    }

    protected ClassLoaderSystem getClassLoaderSystemBean() {
        return (ClassLoaderSystem)this.getBean("ClassLoaderSystem");
    }

    protected void mountJars(URL ... jarUrls) throws IOException, URISyntaxException {
        TempFileProvider tempFileProvider = TempFileProvider.create((String)"test", (ScheduledExecutorService)Executors.newScheduledThreadPool(2));
        for (URL jarUrl : jarUrls) {
            VirtualFile jarFile = VFS.getChild((URL)jarUrl);
            this.mountHandles.add(VFS.mountZip((VirtualFile)jarFile, (VirtualFile)jarFile, (TempFileProvider)tempFileProvider));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        VFSUtils.safeClose(this.mountHandles);
        try {
            if (this.testScenario != null) {
                this.testScenario.destroyLoaders();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected ClassLoaderFactory<CLDeploymentBuilder> getClassLoaderFactory() {
        return new JBossCLFactory(this.getMicrocontainerFacade());
    }

    protected ClassPoolRepository getClassPoolRepository() {
        return (ClassPoolRepository)this.getBean("ClassPoolRepository");
    }

    private MicrocontainerFacade getMicrocontainerFacade() {
        return new MicrocontainerFacadeImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MicrocontainerFacadeImpl
    implements MicrocontainerFacade {
        private MicrocontainerFacadeImpl() {
        }

        @Override
        public void deploy(KernelDeployment deployment) throws Exception {
            JBossClClassPoolTest.this.deploy(deployment);
        }

        @Override
        public Object getBean(Object name) {
            return JBossClClassPoolTest.this.getBean(name);
        }

        @Override
        public Object getBean(Object name, ControllerState state) {
            return JBossClClassPoolTest.this.getBean(name, state);
        }

        @Override
        public <T> T assertBean(Object name, Class<T> expected) {
            return (T)JBossClClassPoolTest.this.assertBean(name, expected);
        }

        @Override
        public void undeploy(KernelDeployment deployment) {
            JBossClClassPoolTest.this.undeploy(deployment);
        }
    }
}

