/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReExportTest<C, L>
extends JBossClClassPoolTest<C, L> {
    protected static final String MODULE_B = "b";
    protected static final String MODULE_A = "a";

    public ReExportTest(String name) {
        super(name);
    }

    public void testReExport() throws Exception {
        this.assertReExport(true);
    }

    public void testNoReExport() throws Exception {
        this.assertReExport(false);
    }

    private void assertReExport(boolean reExport) throws Exception {
        CLDeploymentBuilder clBuilderA = new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL);
        clBuilderA.createModule(MODULE_A).createPackage(SupportClasses.PACKAGE_A).setImportAll(false);
        Object loaderA = this.testScenario.createLoader((ClassLoaderInfo)clBuilderA);
        Object classA = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_C);
        CLDeploymentBuilder clBuilderB = new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL);
        clBuilderB.createModule(MODULE_B).createPackage(SupportClasses.PACKAGE_B).setImportAll(false);
        this.createReExport(clBuilderB);
        Object loaderB = this.testScenario.createLoader((ClassLoaderInfo)clBuilderB);
        Object classA1 = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        ReExportTest.assertSame((Object)classA, (Object)classA1);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_C);
        classA1 = this.testScenario.loadClass(loaderB, loaderA, SupportClasses.CLASS_A);
        ReExportTest.assertSame((Object)classA, (Object)classA1);
        Object classB = this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderB, SupportClasses.CLASS_C);
        CLDeploymentBuilder clBuilderC = new CLDeploymentBuilder("C", SupportArchives.JAR_C_URL);
        clBuilderC.setImportAll(false);
        if (reExport) {
            clBuilderC.createRequireModule(MODULE_B);
        } else {
            clBuilderC.createRequirePackage(SupportClasses.PACKAGE_B);
        }
        Object loaderC = this.testScenario.createLoader((ClassLoaderInfo)clBuilderC);
        classA1 = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        ReExportTest.assertSame((Object)classA, (Object)classA1);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_C);
        classA1 = this.testScenario.loadClass(loaderB, loaderA, SupportClasses.CLASS_A);
        ReExportTest.assertSame((Object)classA, (Object)classA1);
        Object classB1 = this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        ReExportTest.assertSame((Object)classB, (Object)classB1);
        this.testScenario.cannotLoadClass(loaderB, SupportClasses.CLASS_C);
        if (reExport) {
            classA1 = this.testScenario.loadClass(loaderC, loaderA, SupportClasses.CLASS_A);
            ReExportTest.assertSame((Object)classA, (Object)classA1);
        } else {
            this.testScenario.cannotLoadClass(loaderC, SupportClasses.CLASS_A);
        }
        classB1 = this.testScenario.loadClass(loaderC, loaderB, SupportClasses.CLASS_B);
        ReExportTest.assertSame((Object)classB, (Object)classB1);
        this.testScenario.loadClass(loaderC, SupportClasses.CLASS_C);
        this.testScenario.destroyLoader((ClassLoaderInfo)clBuilderC);
        classA1 = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        ReExportTest.assertSame((Object)classA, (Object)classA1);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_C);
        classA1 = this.testScenario.loadClass(loaderB, loaderA, SupportClasses.CLASS_A);
        ReExportTest.assertSame((Object)classA, (Object)classA1);
        classB1 = this.testScenario.loadClass(loaderB, SupportClasses.CLASS_B);
        ReExportTest.assertSame((Object)classB, (Object)classB1);
        this.testScenario.cannotLoadClass(loaderB, SupportClasses.CLASS_C);
        this.testScenario.destroyLoader((ClassLoaderInfo)clBuilderB);
        classA1 = this.testScenario.loadClass(loaderA, SupportClasses.CLASS_A);
        ReExportTest.assertSame((Object)classA, (Object)classA1);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_B);
        this.testScenario.cannotLoadClass(loaderA, SupportClasses.CLASS_C);
    }

    protected abstract void createReExport(CLDeploymentBuilder var1);
}

