/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.classpool.spi.ClassPoolRepository;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.JBossClClassPoolTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.ClassPoolTestScenario;
import org.jboss.test.classpool.support.TestScenario;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceReferencesClassPoolTestCase
extends JBossClClassPoolTest<CtClass, ClassPool> {
    static final String STRING = String.class.getName();
    public final String x = "org.jboss.test.classpool.support.excluded";
    private final Translator TRANSLATOR = new MyTranslator();

    public ReplaceReferencesClassPoolTestCase(String name) {
        super(name);
    }

    @Override
    protected TestScenario<CtClass, ClassPool, CLDeploymentBuilder> getTestScenario() {
        return new ClassPoolTestScenario(this.getClassLoaderFactory(), this.getClassPoolRepository());
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.system.setTranslator(this.TRANSLATOR);
    }

    @Override
    public void tearDown() throws Exception {
        this.system.setTranslator(null);
        super.tearDown();
    }

    public void testParentLoadedParentDelegation() throws Exception {
        ClassPool globalPool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.PARENT_JAR_URL));
        CLDeploymentBuilder childCLBuilder = new CLDeploymentBuilder("SCOPED", SupportArchives.CHILD_JAR_URL);
        childCLBuilder.createDomain("SCOPED", true);
        ClassPool scopedPool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.loadClassAndRunTest(SupportClasses.CLASS_PARENT_CALLER, globalPool.getClassLoader());
        this.loadClassAndRunTest(SupportClasses.CLASS_CHILD_CALLER, scopedPool.getClassLoader());
    }

    public void testParentLoadedNoParentDelegation() throws Exception {
        ClassPool globalPool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.PARENT_JAR_URL));
        CLDeploymentBuilder childCLBuilder = new CLDeploymentBuilder("SCOPED", SupportArchives.CHILD_JAR_URL);
        childCLBuilder.createDomain("SCOPED", false);
        ClassPool scopedPool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.loadClassAndRunTest(SupportClasses.CLASS_PARENT_CALLER, globalPool.getClassLoader());
        this.loadClassAndRunTest(SupportClasses.CLASS_CHILD_CALLER, scopedPool.getClassLoader());
    }

    public void testParentNotLoadedParentDelegation() throws Exception {
        this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.PARENT_JAR_URL));
        CLDeploymentBuilder childCLBuilder = new CLDeploymentBuilder("SCOPED", SupportArchives.CHILD_JAR_URL);
        childCLBuilder.createDomain("SCOPED", true);
        ClassPool scopedPool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.loadClassAndRunTest(SupportClasses.CLASS_CHILD_CALLER, scopedPool.getClassLoader());
    }

    public void testParentNotLoadedNoParentDelegation() throws Exception {
        this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("GLOBAL", SupportArchives.PARENT_JAR_URL));
        CLDeploymentBuilder childCLBuilder = new CLDeploymentBuilder("SCOPED", SupportArchives.CHILD_JAR_URL);
        childCLBuilder.createDomain("SCOPED", false);
        ClassPool scopedPool = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)childCLBuilder);
        this.loadClassAndRunTest(SupportClasses.CLASS_CHILD_CALLER, scopedPool.getClassLoader());
    }

    private void loadClassAndRunTest(String classname, ClassLoader loader) throws Exception {
        Class<?> caller = loader.loadClass(classname);
        Method m = caller.getMethod("test", new Class[0]);
        m.invoke(null, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class MyTranslator
    implements Translator {
        MyTranslator() {
        }

        public void unregisterClassLoader(DomainClassLoader loader) {
        }

        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws Exception {
            if (!className.startsWith(SupportClasses.PACKAGE_REPLACEMENT)) {
                return null;
            }
            if (className.endsWith("Invoked")) {
                return null;
            }
            ClassPool pool = ReplaceReferencesClassPoolTestCase.this.getClassPoolRepository().registerClassLoader(loader);
            CtClass clazz = pool.get(className);
            if (className.endsWith("Caller")) {
                this.instrumentReplaceReferences(clazz);
            } else {
                this.instrumentCreateWrappers(clazz);
            }
            if (clazz.isModified()) {
                return clazz.toBytecode();
            }
            return null;
        }

        private CtClass instrumentCreateWrappers(CtClass clazz) {
            try {
                if (!clazz.getName().startsWith(SupportClasses.PACKAGE_REPLACEMENT)) {
                    return clazz;
                }
                this.addWrappersToClass(clazz);
            }
            catch (Exception e) {
                System.err.println("Exception creating wrappers for " + clazz);
                e.printStackTrace();
            }
            return clazz;
        }

        private CtClass instrumentReplaceReferences(CtClass clazz) throws Exception {
            if (!clazz.getName().startsWith(SupportClasses.PACKAGE_REPLACEMENT)) {
                return clazz;
            }
            this.replaceReferences(clazz);
            return clazz;
        }

        public void unregisterClassLoader(ClassLoader loader) {
        }

        private void addWrappersToClass(CtClass clazz) throws Exception {
            this.addFieldWrappers(clazz);
            this.addConstructorWrappers(clazz);
        }

        private void addFieldWrappers(CtClass clazz) throws Exception {
            CtClass objectCt = clazz.getClassPool().getCtClass(Object.class.getName());
            for (CtField field : clazz.getFields()) {
                if (field.getDeclaringClass() == objectCt) continue;
                CtMethod rmethod = CtNewMethod.make((int)9, (CtClass)CtClass.intType, (String)this.getFieldReadWrapperName(field.getName()), (CtClass[])new CtClass[]{objectCt}, null, (String)("{" + SupportClasses.CLASS_INVOKED + ".invoked = true; return ((" + clazz.getName() + ")$1)." + field.getName() + ";}"), (CtClass)clazz);
                clazz.addMethod(rmethod);
                CtMethod wmethod = CtNewMethod.make((int)9, (CtClass)CtClass.voidType, (String)this.getFieldWriteWrapperName(field.getName()), (CtClass[])new CtClass[]{objectCt, field.getType()}, null, (String)("{" + SupportClasses.CLASS_INVOKED + ".invoked = true; ((" + clazz.getName() + ")$1)." + field.getName() + "=(int)$2;}"), (CtClass)clazz);
                clazz.addMethod(wmethod);
            }
        }

        private void addConstructorWrappers(CtClass clazz) throws Exception {
            for (CtConstructor ctor : clazz.getConstructors()) {
                CtMethod wrapper = CtNewMethod.make((CtClass)clazz, (String)this.getConstructorName(clazz), (CtClass[])ctor.getParameterTypes(), null, (String)("{" + SupportClasses.CLASS_INVOKED + ".invoked = true; return new " + clazz.getName() + "($$);}"), (CtClass)clazz);
                wrapper.setModifiers(9);
                clazz.addMethod(wrapper);
            }
        }

        private void replaceReferences(final CtClass clazz) throws Exception {
            CodeConverter conv = new CodeConverter();
            ClassPoolRepository repository = ReplaceReferencesClassPoolTestCase.this.getClassPoolRepository();
            ScopedClassPool pool = repository.getClassPoolFactory().create(clazz.getClassPool(), (ScopedClassPoolRepository)repository);
            Collection<String> refs = AccessController.doPrivileged(new PrivilegedAction<Collection<String>>(){

                @Override
                public Collection<String> run() {
                    return clazz.getRefClasses();
                }
            });
            for (String ref : refs) {
                CtField[] fields;
                if (!ref.startsWith(SupportClasses.PACKAGE_REPLACEMENT_CHILD) && !ref.startsWith(SupportClasses.PACKAGE_REPLACEMENT_PARENT) || ref.endsWith("Caller")) continue;
                CtClass ctRef = pool.get(ref);
                for (CtField fld : fields = ctRef.getDeclaredFields()) {
                    conv.replaceFieldRead(fld, ctRef, this.getFieldReadWrapperName(fld.getName()));
                    conv.replaceFieldWrite(fld, ctRef, this.getFieldWriteWrapperName(fld.getName()));
                }
                conv.replaceNew(ctRef, ctRef, this.getConstructorName(ctRef));
            }
            clazz.instrument(conv);
        }

        private String getFieldReadWrapperName(String fieldName) {
            return fieldName + "_read";
        }

        private String getFieldWriteWrapperName(String fieldName) {
            return fieldName + "_write";
        }

        private String getConstructorName(CtClass clazz) {
            return clazz.getSimpleName() + "_new";
        }
    }
}

