/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.classpool.jbosscl.test;

import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.test.classpool.jbosscl.support.CLDeploymentBuilder;
import org.jboss.test.classpool.jbosscl.support.SupportArchives;
import org.jboss.test.classpool.jbosscl.support.SupportClasses;
import org.jboss.test.classpool.jbosscl.test.RepositoryTest;
import org.jboss.test.classpool.support.ClassLoaderInfo;
import org.jboss.test.classpool.support.ClassPoolTestScenario;
import org.jboss.test.classpool.support.TestScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryClassPoolTestCase
extends RepositoryTest<CtClass, ClassPool> {
    public RepositoryClassPoolTestCase(String name) {
        super(name);
    }

    @Override
    protected TestScenario<CtClass, ClassPool, CLDeploymentBuilder> getTestScenario() {
        return new ClassPoolTestScenario(this.getClassLoaderFactory(), this.getClassPoolRepository());
    }

    public void testCanLoadArrayCtClass() throws Exception {
        ClassPool poolA = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("A", SupportArchives.JAR_A_URL));
        ClassPool poolB = (ClassPool)this.testScenario.createLoader((ClassLoaderInfo)new CLDeploymentBuilder("B", SupportArchives.JAR_B_URL));
        this.accessCanLoadCtArray(poolA, poolB);
        this.accessCanLoadCtArray(poolA, poolB);
    }

    private void accessCanLoadCtArray(ClassPool poolA, ClassPool poolB) throws Exception {
        poolA.get(String.class.getName() + "[][]");
        CtClass a = poolA.get(SupportClasses.CLASS_A);
        CtClass aArray = poolA.get(SupportClasses.CLASS_A + "[]");
        CtClass bArray = poolA.get(SupportClasses.CLASS_B + "[][]");
        CtClass b = poolA.get(SupportClasses.CLASS_B);
        CtClass byteClassA = poolA.get("byte");
        CtClass byteClassB = poolB.get("byte");
        RepositoryClassPoolTestCase.assertSame((Object)byteClassA, (Object)byteClassB);
        RepositoryClassPoolTestCase.assertNotSame((Object)poolA, (Object)byteClassA.getClassPool());
        RepositoryClassPoolTestCase.assertNotSame((Object)poolB, (Object)byteClassA.getClassPool());
        CtClass intArrayClass = poolA.get("int[]");
        CtClass intClass = poolB.get("int");
        RepositoryClassPoolTestCase.assertSame((Object)intClass, (Object)intArrayClass.getComponentType());
        RepositoryClassPoolTestCase.assertSame((Object)byteClassA.getClassPool(), (Object)intClass.getClassPool());
        RepositoryClassPoolTestCase.assertTrue((boolean)aArray.isArray());
        RepositoryClassPoolTestCase.assertSame((Object)a, (Object)aArray.getComponentType());
        RepositoryClassPoolTestCase.assertTrue((boolean)bArray.isArray());
        RepositoryClassPoolTestCase.assertTrue((boolean)bArray.getComponentType().isArray());
        RepositoryClassPoolTestCase.assertSame((Object)b, (Object)bArray.getComponentType().getComponentType());
        RepositoryClassPoolTestCase.assertNotSame((Object)aArray.getClassPool(), (Object)bArray.getClassPool());
        RepositoryClassPoolTestCase.assertSame((Object)poolA, (Object)aArray.getClassPool());
        RepositoryClassPoolTestCase.assertSame((Object)poolB, (Object)bArray.getClassPool());
        RepositoryClassPoolTestCase.assertSame((Object)a.getClassPool(), (Object)aArray.getClassPool());
        RepositoryClassPoolTestCase.assertSame((Object)b.getClassPool(), (Object)bArray.getClassPool());
    }
}

